/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.scheduler;

import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.internal.scheduler.SchedulerImpl;
import org.eclipse.smarthome.core.scheduler.ScheduledCompletableFuture;
import org.eclipse.smarthome.core.scheduler.Scheduler;
import org.eclipse.smarthome.core.scheduler.SchedulerRunnable;
import org.eclipse.smarthome.core.scheduler.SchedulerTemporalAdjuster;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={Scheduler.class}, immediate=true)
@NonNullByDefault
public class DelegatedSchedulerImpl
implements Scheduler {
    private final Set<ScheduledCompletableFuture<?>> scheduledJobs = new HashSet();
    @NonNullByDefault(value={})
    private SchedulerImpl delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    void deactivate() {
        while (!this.scheduledJobs.isEmpty()) {
            ScheduledCompletableFuture<?> scheduledJob;
            Set<ScheduledCompletableFuture<?>> set = this.scheduledJobs;
            synchronized (set) {
                if (this.scheduledJobs.isEmpty()) {
                    return;
                }
                Iterator<ScheduledCompletableFuture<?>> iterator = this.scheduledJobs.iterator();
                scheduledJob = iterator.next();
                iterator.remove();
            }
            scheduledJob.cancel(true);
        }
    }

    @Override
    public ScheduledCompletableFuture<Instant> after(Duration delay) {
        return this.add(this.delegate.after(delay));
    }

    @Override
    public <T> ScheduledCompletableFuture<T> after(Callable<T> callable, Duration delay) {
        return this.add(this.delegate.after(callable, delay));
    }

    @Override
    public <T> ScheduledCompletableFuture<T> before(CompletableFuture<T> promise, Duration timeout) {
        return this.add(this.delegate.before(promise, timeout));
    }

    @Override
    public ScheduledCompletableFuture<Instant> at(Instant instant) {
        return this.add(this.delegate.at(instant));
    }

    @Override
    public <T> ScheduledCompletableFuture<T> at(Callable<T> callable, Instant instant) {
        return this.add(this.delegate.at(callable, instant));
    }

    @Override
    public <T> ScheduledCompletableFuture<T> schedule(SchedulerRunnable runnable, SchedulerTemporalAdjuster temporalAdjuster) {
        return this.add(this.delegate.schedule(runnable, temporalAdjuster));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ScheduledCompletableFuture<T> add(ScheduledCompletableFuture<T> t) {
        Set<ScheduledCompletableFuture<?>> set = this.scheduledJobs;
        synchronized (set) {
            this.scheduledJobs.add(t);
        }
        t.getPromise().handle((v, e) -> {
            Set<ScheduledCompletableFuture<?>> set = this.scheduledJobs;
            synchronized (set) {
                this.scheduledJobs.remove(t);
                return v;
            }
        });
        return t;
    }

    @Reference
    void setDelegate(SchedulerImpl delegate) {
        this.delegate = delegate;
    }

    void unsetDelegate(SchedulerImpl delegate) {
        this.delegate = null;
    }
}

