/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items.events;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemStateEvent;

public abstract class AbstractItemEventSubscriber
implements EventSubscriber {
    private final Set<String> subscribedEventTypes = Collections.unmodifiableSet(Stream.of(ItemStateEvent.TYPE, ItemCommandEvent.TYPE).collect(Collectors.toSet()));

    @Override
    public Set<String> getSubscribedEventTypes() {
        return this.subscribedEventTypes;
    }

    @Override
    public EventFilter getEventFilter() {
        return null;
    }

    @Override
    public void receive(Event event) {
        if (event instanceof ItemStateEvent) {
            this.receiveUpdate((ItemStateEvent)event);
        } else if (event instanceof ItemCommandEvent) {
            this.receiveCommand((ItemCommandEvent)event);
        }
    }

    protected void receiveCommand(ItemCommandEvent commandEvent) {
    }

    protected void receiveUpdate(ItemStateEvent updateEvent) {
    }
}

