/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items.events;

import org.eclipse.smarthome.core.events.AbstractEvent;
import org.eclipse.smarthome.core.types.State;

public class ItemStateChangedEvent
extends AbstractEvent {
    public static final String TYPE = ItemStateChangedEvent.class.getSimpleName();
    protected final String itemName;
    protected final State itemState;
    protected final State oldItemState;

    protected ItemStateChangedEvent(String topic, String payload, String itemName, State newItemState, State oldItemState) {
        super(topic, payload, null);
        this.itemName = itemName;
        this.itemState = newItemState;
        this.oldItemState = oldItemState;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getItemName() {
        return this.itemName;
    }

    public State getItemState() {
        return this.itemState;
    }

    public State getOldItemState() {
        return this.oldItemState;
    }

    public String toString() {
        return String.format("%s changed from %s to %s", this.itemName, this.oldItemState, this.itemState);
    }
}

