/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateDescriptionFragmentBuilder;
import org.eclipse.smarthome.core.types.UnDefType;
import org.eclipse.smarthome.core.types.util.UnitUtils;

@NonNullByDefault
public class NumberItem
extends GenericItem {
    private static List<Class<? extends State>> acceptedDataTypes = new ArrayList<Class<? extends State>>();
    private static List<Class<? extends Command>> acceptedCommandTypes = new ArrayList<Class<? extends Command>>();
    private @Nullable Class<? extends Quantity<?>> dimension;

    static {
        acceptedDataTypes.add(DecimalType.class);
        acceptedDataTypes.add(QuantityType.class);
        acceptedDataTypes.add(UnDefType.class);
        acceptedCommandTypes.add(DecimalType.class);
        acceptedCommandTypes.add(QuantityType.class);
        acceptedCommandTypes.add(RefreshType.class);
    }

    public NumberItem(String name) {
        this("Number", name);
    }

    public NumberItem(String type, String name) {
        super(type, name);
        String itemTypeExtension = ItemUtil.getItemTypeExtension(this.getType());
        if (itemTypeExtension != null) {
            this.dimension = UnitUtils.parseDimension(itemTypeExtension);
        }
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return Collections.unmodifiableList(acceptedDataTypes);
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return Collections.unmodifiableList(acceptedCommandTypes);
    }

    public void send(DecimalType command) {
        this.internalSend(command);
    }

    @Override
    public @Nullable StateDescription getStateDescription(@Nullable Locale locale) {
        StateDescription stateDescription = super.getStateDescription(locale);
        if (this.getDimension() == null && stateDescription != null && stateDescription.getPattern() != null && stateDescription.getPattern().contains("%unit%")) {
            return StateDescriptionFragmentBuilder.create(stateDescription).withPattern(stateDescription.getPattern().replaceAll("%unit%", "").trim()).build().toStateDescription();
        }
        return stateDescription;
    }

    public @Nullable Class<? extends Quantity<?>> getDimension() {
        return this.dimension;
    }

    @Override
    public void setState(State state) {
        Unit<? extends Quantity<?>> unit;
        if (state instanceof DecimalType && this.dimension != null && (unit = this.getUnit()) != null) {
            super.setState(new QuantityType(((DecimalType)state).doubleValue(), unit));
            return;
        }
        if (state instanceof QuantityType) {
            Unit<? extends Quantity<?>> itemUnit = this.getUnit();
            Unit stateUnit = ((QuantityType)state).getUnit();
            if (itemUnit != null && (!stateUnit.getSystemUnit().equals(itemUnit.getSystemUnit()) || UnitUtils.isDifferentMeasurementSystem(itemUnit, stateUnit))) {
                QuantityType convertedState = ((QuantityType)state).toUnit(itemUnit);
                if (convertedState != null) {
                    super.setState(convertedState);
                    return;
                }
                return;
            }
        }
        if (this.isAcceptedState(acceptedDataTypes, state)) {
            super.setState(state);
        } else {
            this.logSetTypeError(state);
        }
    }

    public @Nullable String getUnitSymbol() {
        Unit<? extends Quantity<?>> unit = this.getUnit();
        return unit != null ? unit.toString() : null;
    }

    public @Nullable Unit<? extends Quantity<?>> getUnit() {
        return this.getUnit(this.dimension);
    }

    public @Nullable QuantityType<?> toQuantityType(DecimalType originalType, @Nullable Class<? extends Quantity<?>> dimension) {
        Unit<? extends Quantity<?>> itemUnit = this.getUnit(dimension);
        if (itemUnit != null) {
            return new QuantityType(originalType.toBigDecimal(), itemUnit);
        }
        return null;
    }

    private @Nullable Unit<? extends Quantity<?>> getUnit(@Nullable Class<? extends Quantity<?>> dimension) {
        Unit<?> stateDescriptionUnit;
        StateDescription stateDescription = this.getStateDescription();
        if (stateDescription != null && (stateDescriptionUnit = UnitUtils.parseUnit(stateDescription.getPattern())) != null) {
            return stateDescriptionUnit;
        }
        if (dimension != null && this.unitProvider != null) {
            return this.unitProvider.getUnit(dimension);
        }
        return null;
    }
}

