/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.http.internal;

import java.util.Deque;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.smarthome.io.http.Handler;
import org.eclipse.smarthome.io.http.HandlerContext;
import org.eclipse.smarthome.io.http.internal.CatchHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHandlerContext
implements HandlerContext {
    private final Logger logger = LoggerFactory.getLogger(DefaultHandlerContext.class);
    private final Deque<Handler> handlers;
    private Iterator<Handler> cursor;
    private Exception error;

    public DefaultHandlerContext(Deque<Handler> handlers) {
        this.handlers = handlers;
        this.cursor = handlers.iterator();
    }

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response) {
        if (this.cursor.hasNext()) {
            boolean hasError = this.hasError();
            CatchHandler handler = new CatchHandler(this.cursor.next());
            if (hasError) {
                handler.handleError(request, response, this);
            } else {
                try {
                    handler.handle(request, response, this);
                }
                catch (Exception e) {
                    if (!this.hasError()) {
                        this.error(e);
                    }
                    this.logger.error("Could not handle request", (Throwable)e);
                }
            }
            if (!hasError && this.hasError()) {
                request.setAttribute("handler.error", (Object)this.error);
                this.cursor = this.handlers.descendingIterator();
                this.execute(request, response);
            }
        }
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public void error(Exception error) {
        this.error = error;
    }
}

