/**
 * Copyright (c) 2014,2019 Contributors to the Eclipse Foundation
 * 
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.model.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smarthome.model.SitemapRuntimeModule;
import org.eclipse.smarthome.model.SitemapStandaloneSetup;
import org.eclipse.smarthome.model.ide.SitemapIdeModule;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class SitemapIdeSetup extends SitemapStandaloneSetup {
  @Override
  public Injector createInjector() {
    SitemapRuntimeModule _sitemapRuntimeModule = new SitemapRuntimeModule();
    SitemapIdeModule _sitemapIdeModule = new SitemapIdeModule();
    return Guice.createInjector(Modules2.mixin(_sitemapRuntimeModule, _sitemapIdeModule));
  }
}
