/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.render;

import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.basic.render.RenderException;
import org.eclipse.smarthome.ui.basic.render.WidgetRenderer;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={WidgetRenderer.class})
public class FrameRenderer
extends AbstractWidgetRenderer {
    @Override
    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
    }

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Frame;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        String snippet = this.getSnippet("frame");
        String label = StringEscapeUtils.escapeHtml((String)this.itemUIRegistry.getLabel(w));
        ArrayList<String> frameClassList = new ArrayList<String>();
        snippet = StringUtils.replace((String)snippet, (String)"%label%", (String)label);
        snippet = StringUtils.replace((String)snippet, (String)"%widget_id%", (String)this.itemUIRegistry.getWidgetId(w));
        if (label.isEmpty()) {
            frameClassList.add("mdl-form--no-label");
        }
        if (!this.itemUIRegistry.getVisiblity(w)) {
            frameClassList.add("mdl-form--hidden");
        }
        String frameClass = StringUtils.join(frameClassList, (char)' ');
        snippet = StringUtils.replace((String)snippet, (String)"%frame_class%", (String)frameClass);
        snippet = this.processColor(w, snippet);
        sb.append(snippet);
        return this.itemUIRegistry.getChildren((LinkableWidget)((Frame)w));
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

