/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentDatasheet.scoping;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentDatasheet;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentDatasheetPackage;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class ComponentDatasheetScopeProvider extends AbstractComponentDatasheetScopeProvider {
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    EReference _componentPortDatasheet_Port = ComponentDatasheetPackage.eINSTANCE.getComponentPortDatasheet_Port();
    boolean _equals = Objects.equal(reference, _componentPortDatasheet_Port);
    if (_equals) {
      final EObject parent = context.eContainer();
      if ((parent instanceof ComponentDatasheet)) {
        ComponentDefinition _component = ((ComponentDatasheet)parent).getComponent();
        boolean _tripleNotEquals = (_component != null);
        if (_tripleNotEquals) {
          return Scopes.scopeFor(Iterables.<ComponentPort>filter(((ComponentDatasheet)parent).getComponent().getElements(), ComponentPort.class));
        } else {
          return IScope.NULLSCOPE;
        }
      }
    }
    return super.getScope(context, reference);
  }
}
