/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentDatasheet.ui;

import java.util.Collection;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.AbstractDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentPortDatasheet;
import org.eclipse.smartmdsd.xtext.base.genericDatasheet.ui.GenericDatasheetProjectPropertiesUpdater;

@SuppressWarnings("all")
public class ComponentDatasheetProjectPropertiesUpdater extends GenericDatasheetProjectPropertiesUpdater {
  @Override
  public String getDatasheetElementName(final AbstractDatasheetElement element) {
    String _xblockexpression = null;
    {
      if ((element instanceof ComponentPortDatasheet)) {
        return ((ComponentPortDatasheet)element).getName();
      }
      _xblockexpression = super.getDatasheetElementName(element);
    }
    return _xblockexpression;
  }
  
  @Override
  public Collection<DatasheetProperty> getDatasheetProperties(final AbstractDatasheetElement element) {
    Collection<DatasheetProperty> _xblockexpression = null;
    {
      if ((element instanceof ComponentPortDatasheet)) {
        return ((ComponentPortDatasheet)element).getProperties();
      }
      _xblockexpression = super.getDatasheetProperties(element);
    }
    return _xblockexpression;
  }
}
