/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 */
package org.eclipse.smartmdsd.xtext.system.causeEffectChain;

import java.util.List;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.ActivityLink;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.CauseEffectChainPackage;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.InputHandlerLink;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@SuppressWarnings("all")
public class CauseEffectChainQNameProvider extends DefaultDeclarativeQualifiedNameProvider {
  public QualifiedName qualifiedName(final ActivityLink link) {
    final QualifiedName parent = super.getFullyQualifiedName(link.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(link, CauseEffectChainPackage.Literals.ACTIVITY_LINK__REF);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = link.eIsSet(CauseEffectChainPackage.Literals.ACTIVITY_LINK__REF);
      if (_eIsSet) {
        return parent.append(link.getRef().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final InputHandlerLink link) {
    final QualifiedName parent = super.getFullyQualifiedName(link.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(link, CauseEffectChainPackage.Literals.INPUT_HANDLER_LINK__REF);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = link.eIsSet(CauseEffectChainPackage.Literals.INPUT_HANDLER_LINK__REF);
      if (_eIsSet) {
        return parent.append(link.getRef().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
}
