/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.componentArchitecture.ui.contentassist;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionPackage;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ComponentParameterInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ParameterStructInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParameterPackage;
import org.eclipse.smartmdsd.xtext.indexer.XtextResourceIndex;
import org.eclipse.smartmdsd.xtext.system.componentArchitecture.ui.contentassist.AbstractComponentArchitectureProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class ComponentArchitectureProposalProvider
extends AbstractComponentArchitectureProposalProvider {
    @Inject
    private XtextResourceIndex index;
    @Inject
    private IQualifiedNameProvider fqn_provider;

    @Override
    public void completeSystemComponentArchitecture_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeSystemComponentArchitecture_Name(model, assignment, context, acceptor);
        URI uri = model.eResource().getURI();
        boolean _isPlatform = uri.isPlatform();
        if (_isPlatform) {
            String projectName = uri.segment(1);
            acceptor.accept(this.createCompletionProposal(projectName, String.valueOf(projectName) + " - ProjectName", this.getImage(model), context));
        }
    }

    @Override
    public void completeComponentInstance_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeComponentInstance_Name(model, assignment, context, acceptor);
        Iterable components = this.index.getVisibleEObjectDescriptions(model, ComponentDefinitionPackage.eINSTANCE.getComponentDefinition());
        Consumer<IEObjectDescription> _function = component -> {
            String name = component.getName().toString();
            String text = String.valueOf(name) + " instantiates " + name + " {\n\n\t}";
            acceptor.accept(this.createCompletionProposal(text, String.valueOf(name) + " - ComponentDefinition", this.getImage(model), context));
        };
        components.forEach(_function);
    }

    @Override
    public void completeParameterStructInstance_Parameter(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject compInstance;
        if (model instanceof ParameterStructInstance && (compInstance = ((ParameterStructInstance)model).eContainer()) instanceof ComponentInstance) {
            Iterable componentParams = this.index.getVisibleEObjectDescriptions(model, SystemParameterPackage.eINSTANCE.getComponentParameterInstance());
            for (IEObjectDescription componentParam : componentParams) {
                boolean _equals;
                EObject object;
                EObject componentParamObj = componentParam.getEObjectOrProxy();
                boolean _eIsProxy = componentParamObj.eIsProxy();
                if (!_eIsProxy || !((object = EcoreUtil.resolve((EObject)componentParamObj, (EObject)compInstance)) instanceof ComponentParameterInstance) || !(_equals = ((ComponentParameterInstance)object).getComponentInstance().equals(compInstance))) continue;
                String text = this.fqn_provider.getFullyQualifiedName(object).toString();
                acceptor.accept(this.createCompletionProposal(text, String.valueOf(text) + " - ComponentParameterInstance", this.getImage(model), context));
            }
        }
    }
}

