/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.base.genericDatasheet.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.smartmdsd.datasheet.indexer.DatasheetProjectSettings;
import org.eclipse.smartmdsd.datasheet.indexer.WorkspaceDatasheetIndexer;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.AbstractDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetModel;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElementNames;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.osgi.service.prefs.Preferences;

public class GenericDatasheetProjectPropertiesUpdater
extends XtextDocumentProvider {
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        super.doSaveDocument(monitor, element, document, overwrite);
        if (element instanceof FileEditorInput) {
            final IProject project = ((FileEditorInput)element).getFile().getProject();
            if (document instanceof IXtextDocument) {
                ((IXtextDocument)document).readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

                    public Object exec(XtextResource resource) throws Exception {
                        GenericDatasheetProjectPropertiesUpdater.this.updateProjectProperties(resource, project);
                        return resource;
                    }
                });
            }
        }
    }

    public void updateProjectProperties(final XtextResource resource, final IProject project) {
        String _name = project.getName();
        String _plus = "Update Datasheet project-settings for " + _name;
        Job job = new Job(_plus){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    WorkspaceDatasheetIndexer indexer = WorkspaceDatasheetIndexer.getInstance();
                    DatasheetProjectSettings settings = indexer.getDatasheetProjectSettings(project.getName());
                    settings.clearAllMainProperties();
                    int index = 0;
                    Collection<AbstractDatasheetElement> _datasheetElements = GenericDatasheetProjectPropertiesUpdater.this.getDatasheetElements(resource);
                    for (AbstractDatasheetElement element : _datasheetElements) {
                        boolean _not;
                        if (element instanceof MandatoryDatasheetElement) {
                            boolean _equals = ((MandatoryDatasheetElement)element).getName().equals((Object)MandatoryDatasheetElementNames.SHORT_DESCRIPTION);
                            if (_equals) {
                                settings.setShortDescription(((MandatoryDatasheetElement)element).getValue());
                                continue;
                            }
                            Preferences property_node = settings.getMainPropertyNode(((MandatoryDatasheetElement)element).getName().getLiteral());
                            settings.updatePropertyValue(property_node, index, ((MandatoryDatasheetElement)element).getValue());
                            ++index;
                            continue;
                        }
                        if (element instanceof DatasheetProperty) {
                            boolean _tripleNotEquals;
                            Preferences property_node_1 = settings.getMainPropertyNode(((DatasheetProperty)element).getName());
                            settings.updatePropertyValue(property_node_1, index, ((DatasheetProperty)element).getValue(), ((DatasheetProperty)element).getUnit());
                            String _semanticID = ((DatasheetProperty)element).getSemanticID();
                            boolean bl = _tripleNotEquals = _semanticID != null;
                            if (_tripleNotEquals) {
                                settings.updatePropertySeminticURI(property_node_1, index, ((DatasheetProperty)element).getSemanticID());
                            }
                            ++index;
                            continue;
                        }
                        String element_name = GenericDatasheetProjectPropertiesUpdater.this.getDatasheetElementName(element);
                        boolean _equals_1 = element_name.equals("");
                        boolean bl = _not = !_equals_1;
                        if (!_not) continue;
                        Preferences custom_node = settings.getCustomSubNode(element_name);
                        custom_node.clear();
                        Collection<DatasheetProperty> _datasheetProperties = GenericDatasheetProjectPropertiesUpdater.this.getDatasheetProperties(element);
                        for (DatasheetProperty property : _datasheetProperties) {
                            boolean _tripleNotEquals_1;
                            Preferences property_node_2 = custom_node.node(property.getName());
                            settings.updatePropertyValue(property_node_2, index, property.getValue(), property.getUnit());
                            String _semanticID_1 = property.getSemanticID();
                            boolean bl2 = _tripleNotEquals_1 = _semanticID_1 != null;
                            if (_tripleNotEquals_1) {
                                settings.updatePropertySeminticURI(property_node_2, index, property.getSemanticID());
                            }
                            ++index;
                        }
                    }
                    settings.saveProperties();
                    return Status.OK_STATUS;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        job.setRule((ISchedulingRule)project);
        job.schedule();
    }

    public Collection<AbstractDatasheetElement> getDatasheetElements(XtextResource resource) {
        ArrayList result = CollectionLiterals.newArrayList();
        EList _contents = resource.getContents();
        for (EObject model : _contents) {
            if (!(model instanceof GenericDatasheetModel)) continue;
            result.addAll(((GenericDatasheetModel)model).getElements());
        }
        return result;
    }

    public String getDatasheetElementName(AbstractDatasheetElement element) {
        return "";
    }

    public Collection<DatasheetProperty> getDatasheetProperties(AbstractDatasheetElement element) {
        return CollectionLiterals.newArrayList();
    }
}

