/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.base.genericDatasheet.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DefaultDatasheetProperties;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetModel;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetPackage;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElementNames;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.TechnologyReadinessLevel;
import org.eclipse.smartmdsd.xtext.base.genericDatasheet.GenericDatasheetUtils;
import org.eclipse.smartmdsd.xtext.base.genericDatasheet.validation.AbstractGenericDatasheetValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GenericDatasheetValidator
extends AbstractGenericDatasheetValidator {
    public static final String INVALID_SPDX_ID = "invalidSpdxId";
    public static final String INVALID_SPDX_URI = "invalidSpdxURI";
    public static final String INVALID_TRL_VALUE = "invalidTRLValue";
    public static final String UNDEFINED_BASE_URI = "undefinedBaseURI";
    public static final String UNDEFINED_SHORT_DESCRIPTION = "undefinedShortDescription";

    @Check
    public void checkMandatoryElements(GenericDatasheetModel model) {
        Functions.Function1 _function_1;
        boolean _exists_1;
        boolean _not_1;
        boolean _not;
        Functions.Function1 _function;
        Iterable mandatory_elements = Iterables.filter((Iterable)model.getElements(), MandatoryDatasheetElement.class);
        boolean _exists = IterableExtensions.exists((Iterable)mandatory_elements, (Functions.Function1)(_function = it -> it.getName().equals((Object)MandatoryDatasheetElementNames.BASE_URI)));
        boolean bl = _not = !_exists;
        if (_not) {
            this.warning("Mandatory Element BaseURI is not defined", null, UNDEFINED_BASE_URI, new String[0]);
        }
        boolean bl2 = _not_1 = !(_exists_1 = IterableExtensions.exists((Iterable)mandatory_elements, (Functions.Function1)(_function_1 = it -> it.getName().equals((Object)MandatoryDatasheetElementNames.SHORT_DESCRIPTION))));
        if (_not_1) {
            this.warning("Mandatory Element ShortDescription is not defined", null, UNDEFINED_SHORT_DESCRIPTION, new String[0]);
        }
    }

    @Check
    public void checkSpdxId(DatasheetProperty property) {
        boolean _equals = property.getName().equals(DefaultDatasheetProperties.SPDX_LICENSE.getLiteral());
        if (_equals) {
            boolean _tripleNotEquals;
            String _value = property.getValue();
            boolean bl = _tripleNotEquals = _value != null;
            if (_tripleNotEquals) {
                String _semanticID;
                boolean _tripleNotEquals_1;
                boolean _not;
                Functions.Function1 _function = it -> it.equals(property.getValue());
                boolean _exists = IterableExtensions.exists(GenericDatasheetUtils.getSpdxLicenseNames(), (Functions.Function1)_function);
                boolean bl2 = _not = !_exists;
                if (_not) {
                    this.warning("Invalid SPDX ID, please use the completion helper by pressing CTRL+Space to get valid IDs", (EStructuralFeature)GenericDatasheetPackage.Literals.DATASHEET_PROPERTY__VALUE, INVALID_SPDX_ID, new String[0]);
                }
                boolean bl3 = _tripleNotEquals_1 = (_semanticID = property.getSemanticID()) != null;
                if (_tripleNotEquals_1) {
                    boolean _not_1;
                    boolean _contains = property.getSemanticID().contains(property.getValue());
                    boolean bl4 = _not_1 = !_contains;
                    if (_not_1) {
                        this.warning("The semantic URI seems not to match the value", (EStructuralFeature)GenericDatasheetPackage.Literals.DATASHEET_PROPERTY__SEMANTIC_ID, INVALID_SPDX_URI, new String[]{property.getValue()});
                    }
                }
            }
        }
    }

    @Check
    public void checkTRLValue(DatasheetProperty property) {
        boolean _equals = property.getName().equals(DefaultDatasheetProperties.TECHNOLOGY_READINESS_LEVEL.getLiteral());
        if (_equals) {
            boolean _not;
            Functions.Function1 _function = it -> {
                String _literal = it.getLiteral();
                String _value = property.getValue();
                return Objects.equal((Object)_literal, (Object)_value);
            };
            boolean _exists = IterableExtensions.exists((Iterable)TechnologyReadinessLevel.VALUES, (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (_not) {
                this.error("Invalid TRL value", (EStructuralFeature)GenericDatasheetPackage.Literals.DATASHEET_PROPERTY__VALUE, INVALID_TRL_VALUE, new String[0]);
            }
        }
    }
}

