/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.communicationObject.ui.quickfix;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectFactory;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.ui.quickfix.BasicAttributesQuickfixProvider;
import org.eclipse.smartmdsd.xtext.service.communicationObject.validation.CommunicationObjectValidator;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Diagnostic;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Custom quickfixes.
 * 
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#quick-fixes
 */
@SuppressWarnings("all")
public class CommunicationObjectQuickfixProvider extends BasicAttributesQuickfixProvider {
  @Fix(CommunicationObjectValidator.INVALID_REPO_NAME)
  public void repoName(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      ((CommObjectsRepository) element).setName(issue.getData()[0]);
    };
    acceptor.accept(issue, 
      "Fix repository name to match project name", 
      "Repository name will be set to project name", 
      "", _function);
  }
  
  @Fix(CommunicationObjectValidator.CAPITAL_COMM_ELEM_NAME)
  public void capitalizeName(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final IModification _function = (IModificationContext context) -> {
      final IXtextDocument xtextDocument = context.getXtextDocument();
      final String firstLetter = xtextDocument.get((issue.getOffset()).intValue(), 1);
      xtextDocument.replace((issue.getOffset()).intValue(), 1, firstLetter.toUpperCase());
    };
    acceptor.accept(issue, "Capitalize name", "Capitalize the name.", "", _function);
  }
  
  @Fix(Diagnostic.LINKING_DIAGNOSTIC)
  public void createMissingCommObject(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final AbstractCommElement currEntity = EcoreUtil2.<AbstractCommElement>getContainerOfType(element, AbstractCommElement.class);
      EObject _eContainer = currEntity.eContainer();
      final CommObjectsRepository model = ((CommObjectsRepository) _eContainer);
      EList<AbstractCommElement> _elements = model.getElements();
      int _indexOf = model.getElements().indexOf(currEntity);
      int _plus = (_indexOf + 1);
      CommunicationObject _createCommunicationObject = CommunicationObjectFactory.eINSTANCE.createCommunicationObject();
      final Procedure1<CommunicationObject> _function_1 = (CommunicationObject it) -> {
        try {
          it.setName(context.getXtextDocument().get((issue.getOffset()).intValue(), (issue.getLength()).intValue()));
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      CommunicationObject _doubleArrow = ObjectExtensions.<CommunicationObject>operator_doubleArrow(_createCommunicationObject, _function_1);
      _elements.add(_plus, _doubleArrow);
    };
    acceptor.accept(issue, 
      "Create missing CommunicationObject", 
      "Create missing CommunicationObject", 
      "", _function);
  }
}
