/********************************************************************************
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.service.domainModelsDatasheet.parser.antlr;

import com.google.inject.Inject;
import org.eclipse.smartmdsd.xtext.service.domainModelsDatasheet.parser.antlr.internal.InternalDomainModelsDatasheetParser;
import org.eclipse.smartmdsd.xtext.service.domainModelsDatasheet.services.DomainModelsDatasheetGrammarAccess;
import org.eclipse.xtext.parser.antlr.AbstractAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;

public class DomainModelsDatasheetParser extends AbstractAntlrParser {

	@Inject
	private DomainModelsDatasheetGrammarAccess grammarAccess;

	@Override
	protected void setInitialHiddenTokens(XtextTokenStream tokenStream) {
		tokenStream.setInitialHiddenTokens("RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT");
	}
	

	@Override
	protected InternalDomainModelsDatasheetParser createParser(XtextTokenStream stream) {
		return new InternalDomainModelsDatasheetParser(stream, getGrammarAccess());
	}

	@Override 
	protected String getDefaultRuleName() {
		return "DomainModelsDatasheet";
	}

	public DomainModelsDatasheetGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(DomainModelsDatasheetGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
}
