/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.DatasheetPropertyCheck;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.SystemDatasheetPropertyChecksModel;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class SystemDatasheetPropertyChecksFormatter extends AbstractFormatter2 {
  protected void _format(final SystemDatasheetPropertyChecksModel systemDatasheetPropertyChecksModel, @Extension final IFormattableDocument document) {
    EList<DatasheetPropertyCheck> _checks = systemDatasheetPropertyChecksModel.getChecks();
    for (final DatasheetPropertyCheck datasheetPropertyCheck : _checks) {
      document.<DatasheetPropertyCheck>format(datasheetPropertyCheck);
    }
  }
  
  public void format(final Object systemDatasheetPropertyChecksModel, final IFormattableDocument document) {
    if (systemDatasheetPropertyChecksModel instanceof XtextResource) {
      _format((XtextResource)systemDatasheetPropertyChecksModel, document);
      return;
    } else if (systemDatasheetPropertyChecksModel instanceof SystemDatasheetPropertyChecksModel) {
      _format((SystemDatasheetPropertyChecksModel)systemDatasheetPropertyChecksModel, document);
      return;
    } else if (systemDatasheetPropertyChecksModel instanceof EObject) {
      _format((EObject)systemDatasheetPropertyChecksModel, document);
      return;
    } else if (systemDatasheetPropertyChecksModel == null) {
      _format((Void)null, document);
      return;
    } else if (systemDatasheetPropertyChecksModel != null) {
      _format(systemDatasheetPropertyChecksModel, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(systemDatasheetPropertyChecksModel, document).toString());
    }
  }
}
