/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.systemParameter;

import java.util.List;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ComponentParameterInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParameterPackage;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@SuppressWarnings("all")
public class SystemParameterQNameProvider extends DefaultDeclarativeQualifiedNameProvider {
  public QualifiedName qualifiedName(final ComponentParameterInstance reference) {
    final QualifiedName parent = super.getFullyQualifiedName(reference.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(reference, SystemParameterPackage.Literals.COMPONENT_PARAMETER_INSTANCE__COMPONENT_INSTANCE);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = reference.eIsSet(SystemParameterPackage.Literals.COMPONENT_PARAMETER_INSTANCE__COMPONENT_INSTANCE);
      if (_eIsSet) {
        return parent.append(reference.getComponentInstance().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
}
