/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.diagram.extension.edit.part;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.ui.services.icon.GetIconOperation;
import org.eclipse.gmf.runtime.common.ui.services.icon.IIconProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.soa.sca.core.common.diagram.ScaDiagramExtensionManager;
import org.eclipse.soa.sca.core.common.diagram.extension.edit.part.ScaElementInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class ScaElementIconProvider
extends AbstractProvider
implements IIconProvider {
    private static ImageRegistry imageRegistry = new ImageRegistry();
    private final String specificationId;

    public ScaElementIconProvider(String specificationId) {
        this.specificationId = specificationId;
    }

    public Image getIcon(IAdaptable hint, int flags) {
        Image result = null;
        IElementType type = (IElementType)hint.getAdapter(IElementType.class);
        if (type != null) {
            for (ScaElementInformation elementInformation : ScaDiagramExtensionManager.INSTANCE.getAllExtensions(this.specificationId)) {
                if (!elementInformation.isKnownElementType(type)) continue;
                result = ScaElementIconProvider.getImage(elementInformation.getIconPath());
                break;
            }
        }
        return result;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof GetIconOperation) {
            return ((GetIconOperation)operation).execute((IProvider)this) != null;
        }
        return false;
    }

    private static Image getImage(String iconPath) {
        Image image = imageRegistry.get(iconPath);
        if (image == null) {
            ImageDescriptor imageDescriptor = null;
            Path p = new Path(iconPath);
            if (p.isAbsolute() && p.segmentCount() > 1) {
                imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
            }
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            imageRegistry.put(iconPath, imageDescriptor);
            image = imageRegistry.get(iconPath);
        }
        return image;
    }
}

