/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.xmleditor.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProposalProcessor
implements ICompletionProposalComputer {
    protected String markupName;
    protected String attributeValue;
    protected String attributeName = null;
    protected String textAfterOffset;
    protected Element element;
    protected IDocument document;
    protected int offset;
    private final Pattern SINGLE_MARKUP_PATTERN = Pattern.compile("^< [^<>]+ />$", 36);
    private final Pattern DOUBLE_MARKUP_PATTERN = Pattern.compile("^< [^<>]+ > .* </ [^<>]+ >$", 36);

    public String getErrorMessage() {
        return null;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        List<Object> result = new ArrayList();
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(context.getDocument());
        IndexedRegion indexedRegion = model.getIndexedRegion(this.offset);
        if (indexedRegion == null) {
            indexedRegion = model.getIndexedRegion(this.offset - 1);
        }
        if (indexedRegion != null) {
            int previousOffet;
            this.offset = context.getInvocationOffset();
            this.document = context.getDocument();
            if (indexedRegion instanceof Element) {
                this.element = (Element)indexedRegion;
                Location location = this.computeContext(indexedRegion);
                result = this.computeCompletionProposals(location);
            } else if (indexedRegion instanceof Text && (previousOffet = indexedRegion.getStartOffset() - 1) > 0 && (indexedRegion = model.getIndexedRegion(previousOffet)) != null && indexedRegion instanceof Element) {
                try {
                    int length = indexedRegion.getEndOffset() - indexedRegion.getStartOffset();
                    String elementText = this.document.get(indexedRegion.getStartOffset(), length);
                    elementText = elementText.trim();
                    elementText = elementText.replace('\n', ' ');
                    elementText = elementText.replace('\r', ' ');
                    this.element = (Element)indexedRegion;
                    if ((this.SINGLE_MARKUP_PATTERN.matcher(elementText).find() || this.DOUBLE_MARKUP_PATTERN.matcher(elementText).find()) && this.element.getParentNode() instanceof Element) {
                        this.element = (Element)this.element.getParentNode();
                        Location location = Location.afterElement;
                        result = this.computeCompletionProposals(location);
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public List computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    protected Location computeContext(IndexedRegion indexedRegion) {
        StringBuffer buf;
        String textBefore = "";
        try {
            textBefore = this.document.get(indexedRegion.getStartOffset(), this.offset - indexedRegion.getStartOffset());
            buf = new StringBuffer();
            char c = 'a';
            int i = this.offset;
            while (this.offset < indexedRegion.getEndOffset() && c != '\"') {
                c = this.document.getChar(i);
                buf.append(c);
                ++i;
            }
            this.textAfterOffset = buf.toString();
        }
        catch (BadLocationException badLocationException) {
            return Location.somewhereElse;
        }
        buf = null;
        int quoteChar = 97;
        Location location = Location.somewhereElse;
        int i = 0;
        while (i < textBefore.length()) {
            char c = textBefore.charAt(i);
            if (c == '<') {
                location = Location.inElement;
                buf = new StringBuffer();
            } else if (c == '\'' || c == '\"') {
                if (quoteChar != 39 && quoteChar != 34) {
                    quoteChar = c;
                    location = Location.inAttributeValue;
                    buf = new StringBuffer();
                } else {
                    quoteChar = 97;
                    buf = null;
                    location = Location.somewhereElse;
                }
            } else if (location == Location.somewhereElse) {
                if (!Character.isWhitespace(c)) {
                    location = Location.inAttributeName;
                    buf = new StringBuffer();
                    buf.append(c);
                } else {
                    this.attributeName = null;
                    this.attributeValue = null;
                }
            } else if (c != '=' && !Character.isWhitespace(c)) {
                buf.append(c);
            } else {
                if (location == Location.inElement) {
                    this.markupName = buf.toString();
                } else if (location == Location.inAttributeName) {
                    this.attributeName = buf.toString();
                } else {
                    this.attributeValue = buf.toString();
                }
                buf = null;
                location = Location.somewhereElse;
            }
            ++i;
        }
        if (location == Location.inElement) {
            this.markupName = buf.toString();
        } else if (location == Location.inAttributeName) {
            this.attributeName = buf.toString();
        } else if (location == Location.inAttributeValue) {
            this.attributeValue = buf.toString();
        }
        return location;
    }

    protected abstract List<ICompletionProposal> computeCompletionProposals(Location var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Location {
        inElement,
        inAttributeName,
        inAttributeValue,
        afterElement,
        somewhereElse;

    }
}

