/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.utils;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ScaCompositeNsFinder {
    public static ScaCompositeNsFinder INSTANCE = new ScaCompositeNsFinder();
    private SAXParser parser;

    private ScaCompositeNsFinder() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this.parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            ScaCoreCommonPlugin.log(e, 4);
            this.parser = null;
        }
        catch (SAXException e) {
            ScaCoreCommonPlugin.log(e, 4);
            this.parser = null;
        }
    }

    public String getNamespaceUri(IFile compositeFile) {
        String result = null;
        if (this.parser != null) {
            ScaSaxHandler saxHandler = new ScaSaxHandler();
            try {
                try {
                    this.parser.parse(compositeFile.getLocation().toFile(), (DefaultHandler)saxHandler);
                }
                catch (SAXException sAXException) {
                    result = saxHandler.nsUri;
                }
                catch (IOException e) {
                    ScaCoreCommonPlugin.log(e, 4);
                    result = saxHandler.nsUri;
                }
            }
            finally {
                result = saxHandler.nsUri;
            }
        }
        return result;
    }

    private static class ScaSaxHandler
    extends DefaultHandler {
        private String nsUri;

        private ScaSaxHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.nsUri = uri;
            throw new SAXException("Interrupting the parsing.");
        }
    }
}

