/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.diagram;

import java.text.MessageFormat;
import java.text.ParsePosition;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.soa.sca.core.common.diagram.Messages;

public abstract class ScaAbstractParser
implements IParser {
    private String viewPattern;
    private MessageFormat viewProcessor;
    private String editPattern;
    private MessageFormat editProcessor;

    public String getViewPattern() {
        return this.viewPattern;
    }

    protected MessageFormat getViewProcessor() {
        return this.viewProcessor;
    }

    public void setViewPattern(String viewPattern) {
        this.viewPattern = viewPattern;
        this.viewProcessor = this.createViewProcessor(viewPattern);
    }

    protected MessageFormat createViewProcessor(String viewPattern) {
        return new MessageFormat(viewPattern);
    }

    public String getEditPattern() {
        return this.editPattern;
    }

    protected MessageFormat getEditProcessor() {
        return this.editProcessor;
    }

    public void setEditPattern(String editPattern) {
        this.editPattern = editPattern;
        this.editProcessor = this.createEditProcessor(editPattern);
    }

    protected MessageFormat createEditProcessor(String editPattern) {
        return new MessageFormat(editPattern);
    }

    public String getPrintString(IAdaptable adapter, int flags) {
        return this.getStringByPattern(adapter, flags, this.getViewPattern(), this.getViewProcessor());
    }

    public String getEditString(IAdaptable adapter, int flags) {
        return this.getStringByPattern(adapter, flags, this.getEditPattern(), this.getEditProcessor());
    }

    protected abstract String getStringByPattern(IAdaptable var1, int var2, String var3, MessageFormat var4);

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        ParsePosition pos = new ParsePosition(0);
        Object[] values = this.getEditProcessor().parse(editString, pos);
        if (values == null) {
            return new ParserEditStatus("org.eclipse.soa.sca.core.common", 1, String.valueOf(Messages.ScaAbstractParser_0) + pos.getErrorIndex());
        }
        return this.validateNewValues(values);
    }

    protected IParserEditStatus validateNewValues(Object[] values) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        Object[] values = this.getEditProcessor().parse(newString, new ParsePosition(0));
        if (values == null || this.validateNewValues(values).getCode() != 0) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.getParseCommand(adapter, values);
    }

    protected abstract ICommand getParseCommand(IAdaptable var1, Object[] var2);

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    protected ICommand getModificationCommand(EObject element, EStructuralFeature feature, Object value) {
        if ((value = this.getValidNewValue(feature, value)) instanceof InvalidValue) {
            return UnexecutableCommand.INSTANCE;
        }
        SetRequest request = new SetRequest(element, feature, value);
        return new SetValueCommand(request);
    }

    protected Object getValidValue(EStructuralFeature feature, Object value) {
        Class iClass;
        EClassifier type = feature.getEType();
        if (type instanceof EDataType && String.class.equals((Object)(iClass = type.getInstanceClass())) && value == null) {
            value = "";
        }
        return value;
    }

    protected Object getValidNewValue(EStructuralFeature feature, Object value) {
        EClassifier type = feature.getEType();
        if (type instanceof EDataType) {
            Class iClass = type.getInstanceClass();
            if (Boolean.TYPE.equals(iClass)) {
                if (!(value instanceof Boolean)) {
                    value = value instanceof String ? Boolean.valueOf((String)value) : new InvalidValue(Messages.ScaAbstractParser_1);
                }
            } else if (Character.TYPE.equals(iClass)) {
                if (!(value instanceof Character)) {
                    String s;
                    value = value instanceof String ? ((s = (String)value).length() == 0 ? null : Character.valueOf(s.charAt(0))) : new InvalidValue(Messages.ScaAbstractParser_2);
                }
            } else if (Byte.TYPE.equals(iClass)) {
                if (!(value instanceof Byte)) {
                    if (value instanceof Number) {
                        value = ((Number)value).byteValue();
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Byte.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new InvalidValue(Messages.ScaAbstractParser_3);
                            }
                        }
                    } else {
                        value = new InvalidValue(Messages.ScaAbstractParser_4);
                    }
                }
            } else if (Short.TYPE.equals(iClass)) {
                if (!(value instanceof Short)) {
                    if (value instanceof Number) {
                        value = ((Number)value).shortValue();
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Short.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new InvalidValue(Messages.ScaAbstractParser_5);
                            }
                        }
                    } else {
                        value = new InvalidValue(Messages.ScaAbstractParser_6);
                    }
                }
            } else if (Integer.TYPE.equals(iClass)) {
                if (!(value instanceof Integer)) {
                    if (value instanceof Number) {
                        value = ((Number)value).intValue();
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Integer.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new InvalidValue(Messages.ScaAbstractParser_7);
                            }
                        }
                    } else {
                        value = new InvalidValue(Messages.ScaAbstractParser_8);
                    }
                }
            } else if (Long.TYPE.equals(iClass)) {
                if (!(value instanceof Long)) {
                    if (value instanceof Number) {
                        value = ((Number)value).longValue();
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Long.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new InvalidValue(Messages.ScaAbstractParser_9);
                            }
                        }
                    } else {
                        value = new InvalidValue(Messages.ScaAbstractParser_10);
                    }
                }
            } else if (Float.TYPE.equals(iClass)) {
                if (!(value instanceof Float)) {
                    if (value instanceof Number) {
                        value = new Float(((Number)value).floatValue());
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Float.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new InvalidValue(Messages.ScaAbstractParser_11);
                            }
                        }
                    } else {
                        value = new InvalidValue(Messages.ScaAbstractParser_12);
                    }
                }
            } else if (Double.TYPE.equals(iClass)) {
                if (!(value instanceof Double)) {
                    if (value instanceof Number) {
                        value = new Double(((Number)value).doubleValue());
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Double.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new InvalidValue(Messages.ScaAbstractParser_13);
                            }
                        }
                    } else {
                        value = new InvalidValue(Messages.ScaAbstractParser_14);
                    }
                }
            } else if (type instanceof EEnum) {
                EEnumLiteral literal;
                value = value instanceof String ? ((literal = ((EEnum)type).getEEnumLiteralByLiteral((String)value)) == null ? new InvalidValue(String.valueOf(Messages.ScaAbstractParser_15) + value) : literal.getInstance()) : new InvalidValue(Messages.ScaAbstractParser_16);
            }
        }
        return value;
    }

    protected static class InvalidValue {
        private final String description;

        public InvalidValue(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

