/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.xmleditor.outline;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.soa.sca.core.common.internal.ScaExtensionManager;
import org.eclipse.soa.sca.core.common.internal.editors.images.ScaImageRegistryManager;
import org.eclipse.soa.sca.core.common.internal.provisional.xmleditor.IImageRegistry;
import org.eclipse.soa.sca.core.common.utils.DomUtils;
import org.eclipse.soa.sca.core.common.utils.ScaXmlUtils;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScaXmlLabelProvider
extends LabelProvider {
    private boolean imageRegistryWasInitialized = false;
    private IImageRegistry imageRegistry;
    private final Map<String, Image> nodeNameToImage = new HashMap<String, Image>();

    public Image getImage(Object element) {
        if (element == null || !Node.class.isAssignableFrom(element.getClass())) {
            return null;
        }
        if (!this.imageRegistryWasInitialized && element instanceof Element) {
            this.imageRegistryWasInitialized = true;
            String nsUri = ((Element)element).getNamespaceURI();
            String id = ScaExtensionManager.INSTANCE.getVersionIdByNamespace(nsUri);
            this.imageRegistry = ScaImageRegistryManager.INSTANCE.getIImageRegistry(id);
        }
        Node node = (Node)element;
        String nodeName = node.getNodeName();
        Image result = null;
        if (nodeName != null) {
            ImageDescriptor desc;
            if (this.nodeNameToImage.containsKey(nodeName)) {
                result = this.nodeNameToImage.get(nodeName);
            } else if (this.imageRegistry != null && (desc = this.imageRegistry.getImageDescriptor(node)) != null) {
                result = desc.createImage();
                this.nodeNameToImage.put(nodeName, result);
            }
        }
        return result;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof Node) {
            Node node = (Node)element;
            String nodeName = DomUtils.getNodeName(node);
            if ((nodeName = nodeName.toLowerCase()).equals("composite") || nodeName.equals("component") || nodeName.equals("service") || nodeName.equals("reference") || nodeName.equals("property")) {
                String name = ScaXmlUtils.getAttributeValue(node, "name");
                return name == null ? "?" : name;
            }
            if (nodeName.equals("include")) {
                String includeName = ScaXmlUtils.getAttributeValue(node, "name");
                includeName = includeName != null ? ScaXmlUtils.removeNamespacePrefix(includeName) : "?";
                int lastIndex = includeName.lastIndexOf(125);
                if (lastIndex > 0) {
                    includeName = lastIndex < includeName.length() - 1 ? includeName.substring(lastIndex + 1) : "";
                }
                return "include " + includeName;
            }
            if (nodeName.equals("wire")) {
                String wireTarget;
                String wireSrc = ScaXmlUtils.getAttributeValue(node, "source");
                if (wireSrc == null) {
                    wireSrc = "";
                }
                if ((wireTarget = ScaXmlUtils.getAttributeValue(node, "target")) == null) {
                    wireTarget = "";
                }
                if (wireSrc.equals("") && wireTarget.equals("")) {
                    return "";
                }
                return String.valueOf(wireSrc) + " > " + wireTarget;
            }
            if (nodeName.startsWith("implementation.") || nodeName.startsWith("binding.") || nodeName.startsWith("interface.")) {
                return nodeName;
            }
            if (nodeName.equals("constrainingtype")) {
                String ctName = ScaXmlUtils.getAttributeValue(node, "name");
                ctName = ctName != null ? ScaXmlUtils.removeNamespacePrefix(ctName) : "?";
                return "Constraining Type " + ctName;
            }
            if (nodeName.equals("bindingtype")) {
                String type = ScaXmlUtils.getAttributeValue(node, "type");
                type = type != null ? ScaXmlUtils.removeNamespacePrefix(type) : "?";
                return "Binding Type " + type;
            }
            if (nodeName.equals("implementationtype")) {
                String type = ScaXmlUtils.getAttributeValue(node, "type");
                type = type != null ? ScaXmlUtils.removeNamespacePrefix(type) : "?";
                return "Implementation Type " + type;
            }
            if (nodeName.equals("runas")) {
                String role = ScaXmlUtils.getAttributeValue(node, "role");
                role = role != null ? ScaXmlUtils.removeNamespacePrefix(role) : "?";
                return "Run As " + role;
            }
            if (nodeName.equals("permitall")) {
                return "Permit All";
            }
            if (nodeName.equals("denyall")) {
                return "Deny All";
            }
            if (nodeName.equals("componenttype")) {
                return "Component Type";
            }
            return nodeName;
        }
        return "";
    }

    public void dispose() {
        for (Image img : this.nodeNameToImage.values()) {
            if (img == null || img.isDisposed()) continue;
            img.dispose();
        }
        this.nodeNameToImage.clear();
        super.dispose();
    }
}

