/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.xmleditor.outline;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.w3c.dom.Node;

public class ScaXmlMouseMoveListener
implements MouseMoveListener {
    private final TreeViewer viewer;

    public ScaXmlMouseMoveListener(TreeViewer viewer) {
        this.viewer = viewer;
        viewer.getTree().addMouseMoveListener((MouseMoveListener)this);
    }

    public void mouseMove(MouseEvent e) {
        if (this.viewer == null) {
            this.removeListener();
            return;
        }
        String tooltip = null;
        TreeItem item = ((Tree)e.widget).getItem(new Point(e.x, e.y));
        if (item != null && item.getData() != null && item.getData() instanceof Node) {
            tooltip = ((Node)item.getData()).getNodeName();
            tooltip = tooltip != null ? tooltip : "";
            int twoDotsPosition = tooltip.indexOf(58);
            if (twoDotsPosition >= 0 && twoDotsPosition < tooltip.length()) {
                tooltip = tooltip.substring(twoDotsPosition + 1);
            }
            if (tooltip.length() == 1) {
                tooltip = tooltip.toUpperCase();
            } else if (tooltip.length() > 1) {
                tooltip = String.valueOf(("" + tooltip.charAt(0)).toUpperCase()) + tooltip.substring(1);
            }
        }
        this.viewer.getTree().setToolTipText(tooltip);
    }

    public void removeListener() {
        if (this.viewer != null && this.viewer.getTree() != null && !this.viewer.getTree().isDisposed()) {
            this.viewer.getTree().removeMouseMoveListener((MouseMoveListener)this);
        }
    }
}

