/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.formeditor.ui;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.soa.sca.core.common.internal.formeditor.Messages;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TableViewerControl
extends Composite {
    private static String FILTER_TEXT = Messages.TableViewerControl_1;
    private final Button add;
    private final Button remove;
    private Button properties;
    private final Text searchText;
    private final TableViewer viewer;
    private LabelProvider labelProvider;
    private IContentProvider contentProvider;
    private final ViewerFilter viewerFilter = new ViewerFilter(){

        public boolean select(Viewer _viewer, Object parentElement, Object element) {
            if (TableViewerControl.this.labelProvider == null) {
                return true;
            }
            String text = TableViewerControl.this.searchText.getText().toLowerCase();
            String string = text = text.equals(FILTER_TEXT) ? "" : text;
            return TableViewerControl.this.labelProvider.getText(element).toLowerCase().startsWith(text);
        }
    };
    private final ISelectionChangedListener defaultChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            boolean isEmptySelection = event.getSelection().isEmpty();
            TableViewerControl.this.remove.setEnabled(!isEmptySelection);
            if (TableViewerControl.this.properties != null) {
                TableViewerControl.this.properties.setEnabled(!isEmptySelection);
            }
        }
    };

    public TableViewerControl(Composite parent, FormToolkit toolkit, boolean addPropertiesButton, boolean useGrid) {
        super(parent, 0);
        toolkit.adapt((Composite)this);
        toolkit.paintBordersFor((Composite)this);
        this.searchText = toolkit.createText((Composite)this, FILTER_TEXT);
        Label fakeLabel = toolkit.createLabel((Composite)this, "");
        fakeLabel.setEnabled(false);
        Table table = toolkit.createTable((Composite)this, 4);
        this.viewer = new TableViewer(table);
        Composite buttonsContainer = toolkit.createComposite((Composite)this);
        this.add = toolkit.createButton(buttonsContainer, Messages.TableViewerControl_2, 8);
        this.remove = toolkit.createButton(buttonsContainer, Messages.TableViewerControl_3, 8);
        if (addPropertiesButton) {
            this.properties = toolkit.createButton(buttonsContainer, Messages.TableViewerControl_6, 8);
        }
        if (useGrid) {
            GridLayout layout = new GridLayout(2, false);
            layout.marginBottom = 20;
            layout.marginLeft = 1;
            this.setLayout((Layout)layout);
            this.setLayoutData(new GridData(1808));
            GridData layoutData = new GridData(768);
            layoutData.widthHint = this.searchText.computeSize((int)-1, (int)-1).x - 20;
            layoutData.horizontalSpan = 1;
            this.searchText.setLayoutData((Object)layoutData);
            table.setLayoutData((Object)new GridData(1808));
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            buttonsContainer.setLayout((Layout)layout);
            buttonsContainer.setLayoutData((Object)new GridData(131072, 128, false, true));
            this.add.setLayoutData((Object)new GridData(768));
            this.remove.setLayoutData((Object)new GridData(768));
            if (addPropertiesButton) {
                this.properties.setLayoutData((Object)new GridData(768));
            }
        } else {
            TableWrapLayout layout = new TableWrapLayout();
            layout.numColumns = 2;
            layout.leftMargin = 1;
            layout.bottomMargin = 20;
            this.setLayout((Layout)layout);
            TableWrapData layoutData = new TableWrapData(256);
            layoutData.grabVertical = true;
            this.setLayoutData(layoutData);
            layoutData = new TableWrapData(128);
            layoutData.colspan = 1;
            this.searchText.setLayoutData((Object)layoutData);
            layoutData = new TableWrapData(256, 256);
            table.setLayoutData((Object)layoutData);
            layout = new TableWrapLayout();
            layout.leftMargin = 0;
            layout.topMargin = 0;
            buttonsContainer.setLayout((Layout)layout);
            this.add.setLayoutData((Object)new TableWrapData(256));
            this.remove.setLayoutData((Object)new TableWrapData(256));
            if (addPropertiesButton) {
                this.properties.setLayoutData((Object)new TableWrapData(256));
            }
        }
        this.remove.setEnabled(false);
        if (this.properties != null) {
            this.properties.setEnabled(false);
        }
        this.viewer.addSelectionChangedListener(this.defaultChangeListener);
        this.viewer.addFilter(this.viewerFilter);
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = TableViewerControl.this.searchText.getText();
                String string = text = text.equals(FILTER_TEXT) ? "" : text;
                if (text.length() > 0) {
                    Color c = Display.getDefault().getSystemColor(2);
                    TableViewerControl.this.searchText.setForeground(c);
                } else {
                    Color c = Display.getDefault().getSystemColor(15);
                    TableViewerControl.this.searchText.setForeground(c);
                }
                TableViewerControl.this.viewer.refresh();
            }
        });
        this.searchText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (TableViewerControl.this.searchText.getText().trim().length() == 0) {
                    TableViewerControl.this.searchText.setText(FILTER_TEXT);
                }
            }

            public void focusGained(FocusEvent e) {
                String text = TableViewerControl.this.searchText.getText();
                if (text.equals(FILTER_TEXT)) {
                    TableViewerControl.this.searchText.setText("");
                } else {
                    TableViewerControl.this.searchText.selectAll();
                }
            }
        });
        this.searchText.notifyListeners(24, new Event());
    }

    public Button getAdd() {
        return this.add;
    }

    public Button getRemove() {
        return this.remove;
    }

    public Button getProperties() {
        return this.properties;
    }

    public LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.viewer.setContentProvider(contentProvider);
    }

    public void addSelectionChangedListener(ISelectionChangedListener selectionListener) {
        this.viewer.addSelectionChangedListener(selectionListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener selectionListener) {
        this.viewer.removeSelectionChangedListener(selectionListener);
    }

    public ISelection getViewerSelection() {
        return this.viewer.getSelection();
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
    }

    public void refreshViewer() {
        this.viewer.refresh();
    }

    public void setFocusOnTable() {
        this.viewer.getTable().setFocus();
    }
}

