/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.common.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.soa.sca.core.common.internal.provisional.utils.IScaSignature;
import org.eclipse.soa.sca.core.common.internal.provisional.utils.ScaValidationEntryBean;
import org.eclipse.soa.sca.core.common.utils.ResourceUtils;
import org.eclipse.soa.sca.sca1_0.common.Messages;
import org.eclipse.soa.sca.sca1_0.common.Sca1_0CommonPlugin;
import org.eclipse.soa.sca.sca1_0.common.builder.ScaBuilderUtils;
import org.eclipse.soa.sca.sca1_0.common.builder.ScaJavaBuildHelper;
import org.eclipse.soa.sca.sca1_0.common.utils.ScaModelUtils;
import org.eclipse.soa.sca.sca1_0.common.utils.ScaSignature;
import org.eclipse.soa.sca.sca1_0.common.utils.SuperComposite;
import org.eclipse.soa.sca.sca1_0.model.sca.Composite;
import org.eclipse.soa.sca.sca1_0.model.sca.Include;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaCompositeBuilderExtension {
    private ScaModelUtils scaModelUtils;

    public Collection<ScaValidationEntryBean> validate(Collection<IFile> filesToValidate, IContainer[] rootContainers) {
        Object message;
        ArrayList<ScaValidationEntryBean> validationResult = new ArrayList<ScaValidationEntryBean>();
        this.scaModelUtils = new ScaModelUtils();
        HashMap<IFile, Composite> fileToComposite = new HashMap<IFile, Composite>();
        for (IFile iFile : filesToValidate) {
            try {
                Composite composite = this.scaModelUtils.getCompositeFile(iFile);
                fileToComposite.put(iFile, composite);
            }
            catch (ScaModelUtils.InvalidScaModelException invalidScaModelException) {
                String filename = iFile.getName();
                String message2 = NLS.bind((String)Messages.IncrementalBuilder_2, (Object)filename);
                validationResult.add(new ScaValidationEntryBean(iFile, message2, 4));
            }
        }
        if (!validationResult.isEmpty()) {
            return validationResult;
        }
        for (Map.Entry entry : fileToComposite.entrySet()) {
            String compositeName;
            String filename2 = ((IFile)entry.getKey()).getName();
            if (filename2.equals(String.valueOf(compositeName = ((Composite)entry.getValue()).getName()) + ".composite")) continue;
            message = NLS.bind((String)Messages.IncrementalBuilder_3, (Object)filename2);
            validationResult.add(new ScaValidationEntryBean((IFile)entry.getKey(), (String)message, 4, (IScaSignature)new ScaSignature((EObject)entry.getValue()), (EObject)entry.getValue()));
        }
        if (!validationResult.isEmpty()) {
            return validationResult;
        }
        HashMap<String, ArrayList<IFile>> hashMap = new HashMap<String, ArrayList<IFile>>();
        message = rootContainers;
        int compositeName = rootContainers.length;
        int filename2 = 0;
        while (filename2 < compositeName) {
            IContainer container = message[filename2];
            Iterator<Include> compositeFiles = ResourceUtils.getFiles((String)"composite", Arrays.asList(container));
            Iterator iterator = compositeFiles.iterator();
            while (iterator.hasNext()) {
                IFile compositeFile = (IFile)iterator.next();
                ArrayList<IFile> f = (ArrayList<IFile>)hashMap.get(compositeFile.getName());
                if (f == null) {
                    f = new ArrayList<IFile>();
                }
                f.add(compositeFile);
                hashMap.put(compositeFile.getName(), f);
            }
            ++filename2;
        }
        for (List f : hashMap.values()) {
            if (f == null || f.size() == 1) continue;
            HashMap<QName, IFile> compositeIds = new HashMap<QName, IFile>();
            for (IFile compositeFile : f) {
                Composite conflictComposite;
                Composite composite = (Composite)fileToComposite.get(compositeFile);
                if (composite == null) {
                    try {
                        composite = this.scaModelUtils.getCompositeFile(compositeFile);
                    }
                    catch (ScaModelUtils.InvalidScaModelException invalidScaModelException) {
                        continue;
                    }
                }
                String name = composite.getName();
                String tns = composite.getTargetNamespace();
                QName id = new QName(tns, name);
                IFile conflictFile = (IFile)compositeIds.get(id);
                if (conflictFile == null) {
                    compositeIds.put(id, compositeFile);
                    continue;
                }
                String message3 = NLS.bind((String)Messages.IncrementalBuilder_5, (Object[])new Object[]{name, tns});
                if (filesToValidate.contains(conflictFile)) {
                    conflictComposite = (Composite)fileToComposite.get(conflictFile);
                    validationResult.add(new ScaValidationEntryBean(conflictFile, message3, 4, (IScaSignature)new ScaSignature((EObject)conflictComposite), (EObject)conflictComposite));
                }
                if (!filesToValidate.contains(compositeFile)) continue;
                conflictComposite = (Composite)fileToComposite.get(conflictFile);
                validationResult.add(new ScaValidationEntryBean(conflictFile, message3, 4, (IScaSignature)new ScaSignature((EObject)conflictComposite), (EObject)conflictComposite));
            }
        }
        if (!validationResult.isEmpty()) {
            return validationResult;
        }
        HashMap<IFile, SuperComposite> fileToSuperComposite = new HashMap<IFile, SuperComposite>();
        for (Map.Entry entry : fileToComposite.entrySet()) {
            SuperComposite sc = new SuperComposite((Composite)entry.getValue(), rootContainers, this.scaModelUtils);
            fileToSuperComposite.put((IFile)entry.getKey(), sc);
        }
        fileToComposite = null;
        for (Map.Entry entry : fileToSuperComposite.entrySet()) {
            for (Include include : ((SuperComposite)((Object)entry.getValue())).getUnresolvedInclusions()) {
                String msg = NLS.bind((String)Messages.ScaCompositeBuilderExtension_2, (Object)include.getName().getLocalPart());
                validationResult.add(new ScaValidationEntryBean((IFile)entry.getKey(), msg, 4, (IScaSignature)new ScaSignature((EObject)entry.getValue()), (EObject)entry.getValue()));
            }
        }
        if (!validationResult.isEmpty()) {
            return validationResult;
        }
        validationResult.addAll(this.getDependencyLoops(fileToSuperComposite));
        if (!validationResult.isEmpty()) {
            return validationResult;
        }
        for (Map.Entry entry : fileToSuperComposite.entrySet()) {
            Diagnostic diagnostic = ScaModelUtils.validate((Composite)entry.getValue());
            validationResult.addAll(ScaBuilderUtils.convertDiagnostics(diagnostic, (IFile)entry.getKey()));
            ScaJavaBuildHelper extendedBuilder = new ScaJavaBuildHelper();
            if (!extendedBuilder.initialize((Composite)entry.getValue(), (IFile)entry.getKey())) continue;
            try {
                validationResult.addAll(extendedBuilder.validatePreRequisites());
                validationResult.addAll(extendedBuilder.validateInterfaceCompatibilityInPromotes());
                validationResult.addAll(extendedBuilder.validateInterfaceCompatibilityInWires());
                validationResult.addAll(extendedBuilder.validateInterfaceImplementations());
                validationResult.addAll(extendedBuilder.validateReferencesInImplementations());
                validationResult.addAll(extendedBuilder.validateOthers());
            }
            catch (Exception e) {
                Sca1_0CommonPlugin.log(e, 4);
            }
        }
        return validationResult;
    }

    private Collection<ScaValidationEntryBean> getDependencyLoops(Map<IFile, SuperComposite> fileToSuperComposite) {
        ArrayList<ScaValidationEntryBean> validationResult = new ArrayList<ScaValidationEntryBean>();
        for (Map.Entry<IFile, SuperComposite> entry : fileToSuperComposite.entrySet()) {
            try {
                this.getAtomicDependencies(entry.getValue(), null);
            }
            catch (DependenciesCycleException e) {
                String rel = String.valueOf(e.loopStart.getName()) + " -> " + e.loopEnd.getName();
                String message = NLS.bind((String)Messages.IncrementalBuilder_8, (Object)rel);
                validationResult.add(new ScaValidationEntryBean(entry.getKey(), message, 4, (IScaSignature)new ScaSignature((EObject)entry.getValue()), (EObject)entry.getValue()));
            }
        }
        return validationResult;
    }

    private List<Composite> getAtomicDependencies(SuperComposite sc, List<Composite> forbiddenInclusions) throws DependenciesCycleException {
        if (forbiddenInclusions == null) {
            forbiddenInclusions = new ArrayList<Composite>();
            forbiddenInclusions.add((Composite)sc);
        }
        ArrayList<Composite> result = new ArrayList<Composite>();
        for (SuperComposite inclusion : sc.getResolvedInclusions()) {
            Composite composite = inclusion.getMainComposite();
            if (forbiddenInclusions.contains(composite)) {
                throw new DependenciesCycleException(composite, sc.getMainComposite());
            }
            result.add(composite);
            forbiddenInclusions.add(composite);
            List<Composite> subResult = this.getAtomicDependencies(inclusion, forbiddenInclusions);
            result.addAll(subResult);
        }
        return result;
    }

    private static class DependenciesCycleException
    extends Exception {
        private static final long serialVersionUID = 7178811675332575864L;
        private final Composite loopStart;
        private final Composite loopEnd;

        DependenciesCycleException(Composite loopStart, Composite loopEnd) {
            this.loopEnd = loopEnd;
            this.loopStart = loopStart;
        }
    }
}

