/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.common.introspection;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.soa.sca.sca1_0.common.Messages;
import org.eclipse.soa.sca.sca1_0.common.Sca1_0CommonPlugin;
import org.eclipse.soa.sca.sca1_0.common.introspection.ComponentTypeFileResolver;
import org.eclipse.soa.sca.sca1_0.common.introspection.Resolver;
import org.eclipse.soa.sca.sca1_0.common.introspection.componenttype.BpelComponentTypeResolver;
import org.eclipse.soa.sca.sca1_0.common.introspection.componenttype.CPPComponentTypeResolver;
import org.eclipse.soa.sca.sca1_0.common.introspection.componenttype.EJBComponentTypeResolver;
import org.eclipse.soa.sca.sca1_0.common.introspection.componenttype.SpringComponentTypeResolver;
import org.eclipse.soa.sca.sca1_0.common.introspection.componenttype.WebComponentTypeResolver;
import org.eclipse.soa.sca.sca1_0.model.sca.Component;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentType;
import org.eclipse.soa.sca.sca1_0.model.sca.Composite;
import org.eclipse.soa.sca.sca1_0.model.sca.DocumentRoot;
import org.eclipse.soa.sca.sca1_0.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_0.model.sca.JavaImplementation;
import org.eclipse.soa.sca.sca1_0.model.sca.ScaPackage;
import org.eclipse.soa.sca.sca1_0.model.sca.util.ScaResourceFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTypeResolver
implements Resolver {
    private final List<ComponentTypeFileResolver> componentTypesFileResolver;
    private final IProject project;

    public ComponentTypeResolver(IProject projectC) {
        this.project = projectC;
        this.componentTypesFileResolver = new ArrayList<ComponentTypeFileResolver>();
        this.componentTypesFileResolver.add(new BpelComponentTypeResolver());
        this.componentTypesFileResolver.add(new CPPComponentTypeResolver());
        this.componentTypesFileResolver.add(new EJBComponentTypeResolver());
        this.componentTypesFileResolver.add(new SpringComponentTypeResolver());
        this.componentTypesFileResolver.add(new WebComponentTypeResolver());
    }

    @Override
    public Composite resolve(Composite composite) {
        for (Component component : composite.getComponent()) {
            this.resolveComponent(component);
        }
        return composite;
    }

    private void resolveComponent(Component component) {
        if (component.getImplementation() == null) {
            return;
        }
        if (component.getImplementation() instanceof JavaImplementation) {
            return;
        }
        ComponentType componentType = this.getComponentType(component.getImplementation());
        if (componentType == null) {
            return;
        }
        this.processComponentType(component, componentType);
    }

    private void processComponentType(Component component, ComponentType componentType) {
        for (ComponentService ctService : componentType.getService()) {
            ComponentService componentService = this.getService(ctService.getName(), (EList<ComponentService>)component.getService());
            if (componentService != null) {
                componentService.getInterface();
                ctService.getInterface();
                continue;
            }
            component.getService().add((Object)ctService);
        }
        for (ComponentReference ctReference : componentType.getReference()) {
            ComponentReference componentRef = this.getReference(ctReference.getName(), (EList<ComponentReference>)component.getReference());
            if (componentRef != null) continue;
            component.getReference().add((Object)ctReference);
        }
    }

    private ComponentService getService(String name, EList<ComponentService> services) {
        for (ComponentService service : services) {
            if (!name.equals(service.getName())) continue;
            return service;
        }
        return null;
    }

    private ComponentReference getReference(String name, EList<ComponentReference> references) {
        for (ComponentReference reference : references) {
            if (!name.equals(reference.getName())) continue;
            return reference;
        }
        return null;
    }

    private ComponentType getComponentType(Implementation implementation) {
        ComponentType result = null;
        ComponentTypeFileResolver componentTypeFileResolver = this.getComponentTypeFileResolver(implementation);
        if (componentTypeFileResolver == null) {
            Sca1_0CommonPlugin.log(NLS.bind((String)Messages.ComponentTypeResolver_2, (Object)implementation.getClass().getCanonicalName()), 2);
            return null;
        }
        URI uri = this.getComponentFileType(componentTypeFileResolver.getFileName(implementation));
        if (uri == null) {
            Sca1_0CommonPlugin.log(NLS.bind((String)Messages.ComponentTypeResolver_3, (Object)componentTypeFileResolver.getFileName(implementation)), 2);
            return null;
        }
        Resource resource = this.getEMFResource(uri);
        if (resource == null) {
            return null;
        }
        result = ((DocumentRoot)resource.getContents().get(0)).getComponentType();
        return result;
    }

    private URI getComponentFileType(String fileName) {
        File projectFile = this.project.getLocation().toFile();
        List<URI> componentTypeFiles = this.getComponentFiles(projectFile, String.valueOf(fileName) + ".componentType");
        if (componentTypeFiles.size() > 0) {
            return componentTypeFiles.get(0);
        }
        return null;
    }

    private ComponentTypeFileResolver getComponentTypeFileResolver(Implementation implementation) {
        ComponentTypeFileResolver result = null;
        Iterator<ComponentTypeFileResolver> it = this.componentTypesFileResolver.iterator();
        while (result == null && it.hasNext()) {
            ComponentTypeFileResolver fileResolver = it.next();
            if (!fileResolver.canBeApplied(implementation)) continue;
            result = fileResolver;
        }
        return result;
    }

    private Resource getEMFResource(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ScaResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.osoa.org/xmlns/sca/1.0", (Object)ScaPackage.eINSTANCE);
        Resource resource = null;
        try {
            resource = resourceSet.getResource(uri, true);
        }
        catch (RuntimeException e) {
            Sca1_0CommonPlugin.log(e, 2, NLS.bind((String)Messages.ComponentTypeResolver_5, (Object)uri.toString()));
            return null;
        }
        return resource;
    }

    private List<URI> getComponentFiles(File file, String fileNameToSearch) {
        ArrayList<URI> result = new ArrayList<URI>();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                result.addAll(this.getComponentFiles(f, fileNameToSearch));
                ++n2;
            }
        } else if (file.getName().toLowerCase().endsWith(fileNameToSearch.toLowerCase())) {
            URI uri = URI.createFileURI((String)file.getAbsolutePath());
            result.add(uri);
        }
        return result;
    }
}

