/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.fields;

import org.eclipse.sphinx.platform.ui.fields.HyperlinkCComboField;
import org.eclipse.sphinx.platform.ui.fields.ICComboButtonField;
import org.eclipse.sphinx.platform.ui.fields.adapters.IButtonAdapter;
import org.eclipse.sphinx.platform.ui.internal.util.LayoutUtil;
import org.eclipse.sphinx.platform.ui.widgets.IWidgetFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkAdapter;

public class HyperlinkCComboButtonField
extends HyperlinkCComboField
implements ICComboButtonField {
    private Button fBrowseButton;
    private String fBrowseButtonLabel = "!Browse...!";
    private IButtonAdapter fButtonAdapter;
    private boolean fButtonEnabled = true;

    public HyperlinkCComboButtonField(int flags, IWidgetFactory widgetFactory, HyperlinkAdapter hyperlinkAdapter, IButtonAdapter buttonAdapter) {
        super(flags, widgetFactory, hyperlinkAdapter);
        this.fButtonAdapter = buttonAdapter;
    }

    @Override
    public void setButtonLabel(String label) {
        this.fBrowseButtonLabel = label;
    }

    private void changeControlPressed() {
        this.fButtonAdapter.changeControlPressed(this);
    }

    @Override
    protected Control[] doFillIntoGrid(Composite parent, int nColumns) {
        Control label = this.getLabelControl(parent, 1);
        CCombo combo = this.getCComboControl(parent, nColumns - 2);
        Button button = this.getChangeControl(parent, 1);
        return new Control[]{label, combo, button};
    }

    @Override
    protected int getNumberOfControls() {
        return 3;
    }

    protected final Button getChangeControl(Composite parent, int hspan) {
        Button button = this.fBrowseButton;
        if (button == null && (button = this.createChangeControl(parent)).getLayoutData() == null) {
            if (this.fUseFormLayout) {
                button.setLayoutData((Object)LayoutUtil.tableWrapDataForButton(button, hspan));
            } else {
                button.setLayoutData((Object)LayoutUtil.gridDataForButton(button, hspan));
            }
        }
        return button;
    }

    private Button createChangeControl(Composite parent) {
        if (this.fBrowseButton == null) {
            this.assertCompositeNotNull(parent);
            int style = -1;
            style = this.fUseFormLayout ? 0x800000 : 8;
            this.fBrowseButton = new Button(parent, style);
            this.fBrowseButton.setFont(parent.getFont());
            this.fBrowseButton.setText(this.fBrowseButtonLabel);
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
            this.fBrowseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    HyperlinkCComboButtonField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    HyperlinkCComboButtonField.this.changeControlPressed();
                }
            });
        }
        return this.fBrowseButton;
    }

    @Override
    public Control getButtonControl() {
        Button control = null;
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            control = this.fBrowseButton;
        }
        return control;
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && enable);
        }
        this.fButtonEnabled = enable;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.dispose();
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
    }
}

