/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.jobs;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.sphinx.xtendxpand.internal.Activator;
import org.eclipse.sphinx.xtendxpand.jobs.CheckJob;
import org.eclipse.sphinx.xtendxpand.jobs.XpandJob;

public class M2TJob
extends WorkspaceJob {
    private CheckJob checkJob;
    private XpandJob xpandJob;

    public M2TJob(String name, XpandJob xpandJob) {
        this(name, xpandJob, null);
    }

    public M2TJob(String name, XpandJob xpandJob, CheckJob checkJob) {
        super(name);
        this.xpandJob = xpandJob;
        this.checkJob = checkJob;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            IStatus status;
            if (this.checkJob != null && ((status = this.checkJob.run((IProgressMonitor)progress.newChild(50))).getSeverity() == 4 || progress.isCanceled())) {
                throw new OperationCanceledException();
            }
            return this.xpandJob.runInWorkspace((IProgressMonitor)progress.newChild(50));
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception ex) {
            return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
        }
    }

    public boolean belongsTo(Object family) {
        return IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
    }

    public CheckJob getCheckJob() {
        return this.checkJob;
    }

    public XpandJob getXpandJob() {
        return this.xpandJob;
    }
}

