/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.editor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.compare.ui.editor.ModelComparisonScopeEditorInput;
import org.eclipse.sphinx.emf.compare.ui.internal.Activator;
import org.eclipse.sphinx.emf.compare.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.editors.DefaultModelEditorInputChangeHandler;
import org.eclipse.sphinx.emf.editors.IModelEditorInputChangeAnalyzer;
import org.eclipse.sphinx.emf.editors.IModelEditorInputChangeHandler;
import org.eclipse.sphinx.emf.editors.ModelEditorInputSynchronizer;
import org.eclipse.sphinx.emf.editors.ModelEditorUndoContextManager;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveablesProvider;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SaveablesLifecycleEvent;

public class ModelCompareEditor
extends CompareEditor
implements IModelEditorInputChangeAnalyzer {
    public static String ID = "org.eclipse.sphinx.emf.compare.ui.editors.modelCompareEditor";
    protected ModelEditorUndoContextManager undoContextManager;
    protected ModelEditorInputSynchronizer editorInputSynchronizer;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        TransactionalEditingDomain editingDomain;
        super.init(site, input);
        this.undoContextManager = this.getModelEditorUndoContextManager();
        TransactionalEditingDomain transactionalEditingDomain = editingDomain = this.getEditingDomains()[0] != null ? this.getEditingDomains()[0] : this.getEditingDomains()[1];
        if (editingDomain != null) {
            this.editorInputSynchronizer = new ModelEditorInputSynchronizer(input, editingDomain, (IModelEditorInputChangeAnalyzer)this, (IModelEditorInputChangeHandler)new ModelCompareEditorInputChangeHandler());
        }
    }

    protected ModelEditorUndoContextManager getModelEditorUndoContextManager() {
        if (this.undoContextManager == null) {
            this.undoContextManager = this.createModelEditorUndoContextManager();
        }
        return this.undoContextManager;
    }

    protected ModelEditorUndoContextManager createModelEditorUndoContextManager() {
        TransactionalEditingDomain editingDomain = this.getEditingDomains()[0] != null ? this.getEditingDomains()[0] : this.getEditingDomains()[1];
        return new ModelEditorUndoContextManager(this.getSite(), (IWorkbenchPart)this, editingDomain);
    }

    public void dispose() {
        if (this.undoContextManager != null) {
            this.undoContextManager.dispose();
        }
        super.dispose();
    }

    public ISaveablesLifecycleListener createModelSaveablesLifecycleListener() {
        return new BasicModelSaveablesProvider.SiteNotifyingSaveablesLifecycleListener((IWorkbenchPart)this){

            public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
                super.handleLifecycleEvent(event);
                if (event.getEventType() == 4) {
                    ModelCompareEditor.this.firePropertyChange(257);
                }
            }
        };
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IUndoContext.class)) {
            return this.getModelEditorUndoContextManager().getUndoContext();
        }
        return super.getAdapter(key);
    }

    public TransactionalEditingDomain[] getEditingDomains() {
        TransactionalEditingDomain[] editingDomains = new TransactionalEditingDomain[2];
        Object[] modelRoots = this.getModelRoots();
        if (modelRoots[0] != null) {
            editingDomains[0] = WorkspaceEditingDomainUtil.getEditingDomain((Object)modelRoots[0]);
        }
        if (modelRoots[1] != null) {
            editingDomains[1] = WorkspaceEditingDomainUtil.getEditingDomain((Object)modelRoots[1]);
        }
        return editingDomains;
    }

    public Object[] getModelRoots() {
        Object[] modelRoots = new Object[2];
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof ModelComparisonScopeEditorInput) {
            modelRoots[0] = ((ModelComparisonScopeEditorInput)editorInput).getLeftObject();
            modelRoots[1] = ((ModelComparisonScopeEditorInput)editorInput).getRightObject();
        }
        return modelRoots;
    }

    protected AdapterFactory[] getAdapterFactories() {
        AdapterFactory[] adapterFactories = new AdapterFactory[2];
        TransactionalEditingDomain[] editingDomains = this.getEditingDomains();
        int i = 0;
        while (i < 2) {
            TransactionalEditingDomain editingDomain = editingDomains[i];
            if (editingDomain != null) {
                adapterFactories[i] = ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
            }
            ++i;
        }
        return adapterFactories;
    }

    protected AdapterFactoryItemDelegator[] getItemDelegators() {
        AdapterFactoryItemDelegator[] itemDelegators = new AdapterFactoryItemDelegator[2];
        AdapterFactory[] adapterFactories = this.getAdapterFactories();
        int i = 0;
        while (i < 2) {
            AdapterFactory adapterFactory = adapterFactories[i];
            if (adapterFactory != null) {
                itemDelegators[i] = new AdapterFactoryItemDelegator(adapterFactory);
            }
            ++i;
        }
        return itemDelegators;
    }

    protected boolean isActivePart() {
        return this == this.getSite().getWorkbenchWindow().getPartService().getActivePart();
    }

    public void setInput(IEditorInput input) {
        if (input instanceof ModelComparisonScopeEditorInput) {
            super.setInput(input);
        } else {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)new RuntimeException(Messages.error_invalidEditorInput));
        }
    }

    public boolean containsEditorInputObject(IEditorInput editorInput, Set<EObject> objects) {
        if (objects != null && editorInput instanceof ModelComparisonScopeEditorInput) {
            Object leftObject = ((ModelComparisonScopeEditorInput)editorInput).getLeftObject();
            Object rightObject = ((ModelComparisonScopeEditorInput)editorInput).getRightObject();
            return objects.contains(leftObject) || objects.contains(rightObject);
        }
        return false;
    }

    public boolean containsEditorInputResourceURI(IEditorInput editorInput, Set<URI> resourceURIs) {
        if (resourceURIs != null && editorInput instanceof ModelComparisonScopeEditorInput) {
            Resource rightResource;
            HashSet<URI> editorInputResourceURIs = new HashSet<URI>();
            Resource leftResource = ((ModelComparisonScopeEditorInput)editorInput).getLeftResource();
            if (leftResource != null) {
                editorInputResourceURIs.add(leftResource.getURI());
            }
            if ((rightResource = ((ModelComparisonScopeEditorInput)editorInput).getRightResource()) != null) {
                editorInputResourceURIs.add(rightResource.getURI());
            }
            for (URI editorInputResourceURI : editorInputResourceURIs) {
                if (!resourceURIs.contains(editorInputResourceURI)) continue;
                return true;
            }
        }
        return false;
    }

    public class ModelCompareEditorInputChangeHandler
    extends DefaultModelEditorInputChangeHandler {
        public void handleEditorInputObjectRemoved(IEditorInput editorInput, Set<EObject> removedObjects) {
            this.close();
        }

        public void handleEditorInputObjectMoved(IEditorInput editorInput, Set<EObject> movedObjects) {
            this.close();
        }

        public void handleEditorInputResourceMoved(IEditorInput editorInput, URI oldURI, URI newURI) {
        }

        public void handleEditorInputResourceRemoved(IEditorInput editorInput) {
            this.close();
        }

        protected void close() {
            Display display = ModelCompareEditor.this.getSite().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ModelCompareEditor.this.getSite().getPage().closeEditor((IEditorPart)ModelCompareEditor.this, false);
                }
            });
        }

        protected void updateEditorInput(IEditorInput oldEditorInput, IEditorInput newEditorInput) {
            Assert.isNotNull((Object)newEditorInput);
            if (!newEditorInput.equals(oldEditorInput)) {
                ModelCompareEditor.this.setInputWithNotify(newEditorInput);
                ModelCompareEditor.this.setTitleToolTip(ModelCompareEditor.this.getTitleToolTip());
            }
        }
    }
}

