/**
 * <copyright>
 *
 * Copyright (c) 2014-2017 itemis, IncQuery Labs and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     itemis - Initial API and implementation
 *     itemis - [475954] Proxies with fragment-based proxy URIs may get resolved across model boundaries
 *     IncQuery Labs, itemis - [501899] Use base index instead of IncQuery patterns
 *
 * </copyright>
 */
package org.eclipse.sphinx.emf.workspace.viatra.query;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.resource.ScopingResourceSet;
import org.eclipse.sphinx.emf.viatra.query.ViatraQueryEngineHelper;
import org.eclipse.sphinx.emf.workspace.viatra.query.internal.DelegatingScopingResourceSetImpl;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public class WorkspaceViatraQueryEngineHelper extends ViatraQueryEngineHelper implements IWorkspaceViatraQueryEngineHelper {

	@Override
	public ViatraQueryEngine getEngine(Resource contextResource) throws ViatraQueryException {
		IModelDescriptor contextModelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(contextResource);
		if (contextModelDescriptor != null) {
			return getEngine(contextModelDescriptor);
		}
		return getEngine(contextResource, false);
	}

	@Override
	public ViatraQueryEngine getEngine(IModelDescriptor contextModelDescriptor) throws ViatraQueryException {
		if (contextModelDescriptor != null) {
			ResourceSet resourceSet = contextModelDescriptor.getEditingDomain().getResourceSet();
			if (resourceSet instanceof ScopingResourceSet) {
				DelegatingScopingResourceSetImpl delegatingResourceSet = new DelegatingScopingResourceSetImpl((ScopingResourceSet) resourceSet,
						contextModelDescriptor);
				return ViatraQueryEngine.on(new EMFScope(delegatingResourceSet));
			}
			return ViatraQueryEngine.on(new EMFScope(resourceSet));
		}
		return null;
	}
}
