/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.internal.saving;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.sphinx.emf.saving.IResourceSaveIndicator;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.workspace.saving.ModelSaveManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSaveIndicator
implements IResourceSaveIndicator {
    private TransactionalEditingDomain editingDomain;
    private Set<Resource> dirtyResources = Collections.synchronizedSet(new HashSet());
    private Set<URI> savedURIs = Collections.synchronizedSet(new HashSet());
    protected ResourceSetListener objectChangedListener;

    public ResourceSaveIndicator(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.addTransactionalEditingDomainListeners();
    }

    public void dispose() {
        this.removeTransactionalEditingDomainListeners();
    }

    protected void addTransactionalEditingDomainListeners() {
        this.objectChangedListener = this.createObjectChangedListener();
        Assert.isNotNull((Object)this.objectChangedListener);
        if (this.editingDomain != null) {
            this.editingDomain.addResourceSetListener(this.objectChangedListener);
        }
    }

    protected void removeTransactionalEditingDomainListeners() {
        if (this.editingDomain != null && this.objectChangedListener != null) {
            this.editingDomain.removeResourceSetListener(this.objectChangedListener);
        }
    }

    protected ResourceSetListener createObjectChangedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createNotifierTypeFilter(Resource.class).negated().and(NotificationFilter.createEventTypeFilter((int)9).negated())){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                ResourceSaveIndicator.this.makeDirty(ResourceUndoContext.getAffectedResources((List)event.getNotifications()));
            }
        };
    }

    protected void makeDirty(Set<Resource> resources) {
        for (Resource resource : resources) {
            this.setDirty(resource);
            ModelSaveManager.INSTANCE.notifyDirtyChanged(resource);
        }
    }

    public boolean handleResourceChanged(Resource resource) {
        this.unsetSaved(resource);
        return true;
    }

    public boolean handleResourceDeleted(Resource resource) {
        return true;
    }

    public boolean handleResourceMoved(Resource resource, URI newURI) {
        return true;
    }

    public boolean isDirty(Resource resource) {
        return this.dirtyResources.contains(resource);
    }

    public void setDirty(Resource resource) {
        if (resource != null && EcoreResourceUtil.exists((URI)resource.getURI())) {
            this.dirtyResources.add(resource);
        }
    }

    public Collection<Resource> getDirtyResources() {
        return Collections.unmodifiableSet(new HashSet<Resource>(this.dirtyResources));
    }

    public boolean isSaved(URI uri) {
        return this.savedURIs.contains(uri);
    }

    public void setSaved(Resource resource) {
        if (resource != null) {
            this.setSaved(Collections.singletonList(resource));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSaved(Collection<Resource> resources) {
        if (resources != null) {
            Set<URI> set = this.savedURIs;
            synchronized (set) {
                for (Resource resource : resources) {
                    this.savedURIs.add(resource.getURI());
                    this.dirtyResources.remove(resource);
                }
            }
        }
    }

    private void unsetSaved(Resource resource) {
        this.savedURIs.remove(resource.getURI());
    }
}

