/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.actions.providers;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sphinx.emf.ui.internal.Activator;
import org.eclipse.sphinx.emf.ui.util.EcoreUIUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenWithMenu
extends ContributionItem {
    private IWorkbenchPage page;
    private EObject eObject;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    public static final String ID = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".ObjectOpenWithMenu";
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            String s1 = ((IEditorDescriptor)arg0).getLabel();
            String s2 = ((IEditorDescriptor)arg1).getLabel();
            return this.collator.compare(s1, s2);
        }
    };

    public OpenWithMenu(IWorkbenchPage page, EObject object) {
        super(ID);
        this.page = page;
        this.eObject = object;
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        return Activator.INSTANCE.getResourceManager().createImage(imageDesc);
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(EcoreUIUtil.getDummyFileName(this.eObject.eClass())) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(EcoreUIUtil.getDummyFileName(this.eObject.eClass()));
        }
        return imageDesc;
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenu.this.openEditor(descriptor);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        IEditorDescriptor defaultEditor;
        if (this.eObject == null) {
            return;
        }
        IEditorDescriptor preferredEditor = defaultEditor = EcoreUIUtil.getDefaultEditor(this.eObject);
        IEditorDescriptor[] editors = EcoreUIUtil.getEditors(this.eObject);
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        IEditorDescriptor[] iEditorDescriptorArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor editor2 = iEditorDescriptorArray[n2];
            IEditorDescriptor editor = editor2;
            if (!alreadyMapped.contains(editor)) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++n2;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
    }

    public boolean isDynamic() {
        return true;
    }

    protected void openEditor(IEditorDescriptor editorDescriptor) {
        if (this.eObject == null) {
            return;
        }
        if (this.page != null) {
            try {
                URIEditorInput editorInput = EcoreUIUtil.createURIEditorInput(this.eObject);
                if (editorInput != null) {
                    this.page.openEditor((IEditorInput)editorInput, editorDescriptor.getId());
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
    }
}

