/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.viewers.filters;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ElementTypeNameViewerFilter
extends ViewerFilter {
    protected boolean accept;
    protected Set<String> typeNames;

    public ElementTypeNameViewerFilter(boolean accept) {
        this(null, accept);
    }

    public ElementTypeNameViewerFilter(Set<String> typeNames, boolean accept) {
        this.typeNames = typeNames != null ? typeNames : new HashSet<String>(Arrays.asList(this.getTypeNames()));
        this.accept = accept;
    }

    protected String[] getTypeNames() {
        return new String[0];
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element != null) {
            if (this.typeNames.contains(element.getClass().getSimpleName())) {
                return this.accept;
            }
            if (this.matchesSupertypeOf(element.getClass())) {
                return this.accept;
            }
            return !this.accept;
        }
        return true;
    }

    protected boolean matchesSupertypeOf(Class<?> elementType) {
        Class<?>[] interfaces;
        Class<?> superClass;
        HashSet superTypes = new HashSet();
        if (!elementType.isInterface() && (superClass = elementType.getSuperclass()) != null) {
            superTypes.add(superClass);
            if (this.typeNames.contains(superClass.getSimpleName())) {
                this.typeNames.add(superClass.getSimpleName());
                return true;
            }
        }
        Class<?>[] classArray = interfaces = elementType.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            superTypes.add(clazz);
            if (this.typeNames.contains(clazz.getSimpleName())) {
                this.typeNames.add(clazz.getSimpleName());
                return true;
            }
            ++n2;
        }
        for (Class clazz : superTypes) {
            if (!this.matchesSupertypeOf(clazz)) continue;
            return true;
        }
        return false;
    }
}

