/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.SchedulingRuleFactory;
import org.eclipse.sphinx.platform.operations.AbstractWorkspaceOperation;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class UnresolveUnreachableCrossProjectReferencesOperation
extends AbstractWorkspaceOperation {
    private Collection<IProject> projectsWithUnreachableCrossRefrencesToUnresolve;

    public UnresolveUnreachableCrossProjectReferencesOperation(Collection<IProject> projectsWithUnreachableCrossRefrencesToUnresolve) {
        super(Messages.job_unresolvingUnreachableCrossProjectReferences);
        this.projectsWithUnreachableCrossRefrencesToUnresolve = projectsWithUnreachableCrossRefrencesToUnresolve;
    }

    public ISchedulingRule getRule() {
        return new SchedulingRuleFactory().createLoadSchedulingRule(this.projectsWithUnreachableCrossRefrencesToUnresolve, false);
    }

    public Collection<IProject> getProjectsWithUnreachableCrossRefrencesToUnresolve() {
        return this.projectsWithUnreachableCrossRefrencesToUnresolve;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.runUnresolveUnreachableCrossProjectReferences(this.projectsWithUnreachableCrossRefrencesToUnresolve, monitor);
    }

    private void runUnresolveUnreachableCrossProjectReferences(Collection<IProject> projects, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(projects);
        for (IProject project : projects) {
            Collection modelsInProject = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project);
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.task_unresolvingUnreachableCrossProjectReferencesInProject, (Object)project.getName()), (int)modelsInProject.size());
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            for (IModelDescriptor modelDescriptor : modelsInProject) {
                this.unresolveUnreachableCrossProjectReferencesInModel(modelDescriptor, (IProgressMonitor)progress.newChild(1));
                if (!progress.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
    }

    private void unresolveUnreachableCrossProjectReferencesInModel(final IModelDescriptor modelDescriptor, final IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull((Object)modelDescriptor);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Collection resources = modelDescriptor.getLoadedResources(true);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)resources.size());
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                for (Resource resource : resources) {
                    progress.subTask(NLS.bind((String)Messages.subtask_unresolvingUnreachableCrossProjectReferencesInResource, (Object)resource.getURI()));
                    try {
                        TreeIterator allContents = resource.getAllContents();
                        while (allContents.hasNext()) {
                            EObject object = (EObject)allContents.next();
                            for (EReference reference : object.eClass().getEAllReferences()) {
                                if (reference.isContainment() || reference.isContainer()) continue;
                                if (reference.isMany()) {
                                    EList referencedObjects = (EList)object.eGet((EStructuralFeature)reference);
                                    if (referencedObjects instanceof BasicEList.UnmodifiableEList) continue;
                                    ArrayList safeReferencedObjects = new ArrayList(referencedObjects);
                                    for (EObject referencedObject : safeReferencedObjects) {
                                        if (referencedObject == null || referencedObject.eIsProxy() || modelDescriptor.getScope().belongsTo(referencedObject.eResource(), true)) continue;
                                        referencedObjects.remove((Object)referencedObject);
                                        referencedObjects.add((Object)EObjectUtil.createProxyFrom((EObject)referencedObject, (Resource)object.eResource()));
                                    }
                                    continue;
                                }
                                EObject referencedObject = (EObject)object.eGet((EStructuralFeature)reference);
                                if (referencedObject == null || referencedObject.eIsProxy() || modelDescriptor.getScope().belongsTo(referencedObject.eResource(), true)) continue;
                                object.eSet((EStructuralFeature)reference, (Object)EObjectUtil.createProxyFrom((EObject)referencedObject, (Resource)object.eResource()));
                            }
                            if (!progress.isCanceled()) continue;
                            throw new OperationCanceledException();
                        }
                    }
                    catch (Exception ex) {
                        PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                    progress.worked(1);
                    progress.subTask("");
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    modelDescriptor.getEditingDomain().yield();
                }
            }
        };
        try {
            IOperationHistory operationHistory = WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)modelDescriptor.getEditingDomain());
            Map options = WorkspaceTransactionUtil.getDefaultTransactionOptions();
            options.put("no_undo", Boolean.TRUE);
            WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)modelDescriptor.getEditingDomain(), (Runnable)runnable, (String)Messages.operation_unresolvingUnreachableCrossProjectReferencesInModel, (IOperationHistory)operationHistory, (Map)options, null);
        }
        catch (ExecutionException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
    }
}

