/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.incquery.proxymanagment;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.sphinx.emf.ecore.proxymanagement.IProxyResolver;
import org.eclipse.sphinx.emf.incquery.AbstractIncQueryProvider;
import org.eclipse.sphinx.emf.incquery.internal.Activator;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractProxyResolver
extends AbstractIncQueryProvider
implements IProxyResolver {
    protected abstract EObject[] getEObjectCandidates(EObject var1, Object var2, IncQueryEngine var3);

    protected abstract EObject[] getEObjectCandidates(URI var1, Object var2, IncQueryEngine var3);

    protected Class<?> getInstanceClass(EObject proxy) {
        if (proxy != null && proxy.eClass() != null) {
            return proxy.eClass().getInstanceClass();
        }
        return null;
    }

    protected EObject getMatchingEObject(EObject proxy, EObject[] eObjectCandidates) {
        if (proxy != null && eObjectCandidates != null) {
            EObject[] eObjectArray = eObjectCandidates;
            int n = eObjectCandidates.length;
            int n2 = 0;
            while (n2 < n) {
                EObject eObj = eObjectArray[n2];
                if (this.matches(proxy, eObj)) {
                    return eObj;
                }
                ++n2;
            }
        }
        return null;
    }

    protected EObject getMatchingEObject(URI uri, EObject[] eObjectCandidates) {
        if (uri != null && eObjectCandidates != null) {
            EObject[] eObjectArray = eObjectCandidates;
            int n = eObjectCandidates.length;
            int n2 = 0;
            while (n2 < n) {
                EObject eObj = eObjectArray[n2];
                if (this.matches(uri, eObj)) {
                    return eObj;
                }
                ++n2;
            }
        }
        return null;
    }

    protected boolean matches(EObject proxy, EObject candidate) {
        URI proxyURI = ((InternalEObject)proxy).eProxyURI();
        return this.matches(proxyURI, candidate);
    }

    protected boolean matches(URI proxyURI, EObject candidate) {
        proxyURI = proxyURI.trimQuery();
        URI candidateURI = EcoreResourceUtil.getURI((EObject)candidate);
        return proxyURI.equals(candidateURI);
    }

    public boolean canResolve(EObject eObject) {
        if (eObject != null) {
            return this.canResolve(eObject.eClass());
        }
        return false;
    }

    public boolean canResolve(EClass eType) {
        if (eType != null) {
            return this.getSupportedTypes().contains(eType.getInstanceClass()) && !eType.isAbstract() && !eType.isInterface();
        }
        return false;
    }

    public EObject getEObject(EObject proxy, EObject contextObject, boolean loadOnDemand) {
        try {
            IncQueryEngine engine = this.getIncQueryEngineHelper().getEngine(contextObject.eResource());
            EObject[] eObjectCandidates = this.getEObjectCandidates(proxy, (Object)contextObject, engine);
            return this.getMatchingEObject(proxy, eObjectCandidates);
        }
        catch (IncQueryException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            return null;
        }
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        try {
            Resource contextResource = this.getContextResource(uri);
            if (contextResource != null) {
                IncQueryEngine engine = this.getIncQueryEngineHelper().getEngine(contextResource);
                EObject[] eObjectCandidates = this.getEObjectCandidates(uri, (Object)contextResource, engine);
                return this.getMatchingEObject(uri, eObjectCandidates);
            }
        }
        catch (IncQueryException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
        return null;
    }

    protected Resource getContextResource(URI proxyURI) {
        return EcorePlatformUtil.getResource((URI)proxyURI.trimFragment());
    }
}

