/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.css.swt.dom.scrollbar;

import org.eclipse.e4.ui.internal.css.swt.dom.scrollbar.AbstractThemedScrollBarAdapter;
import org.eclipse.e4.ui.internal.css.swt.dom.scrollbar.IScrollBarSettings;
import org.eclipse.e4.ui.internal.css.swt.dom.scrollbar.ScrollBarPositions;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

abstract class AbstractScrollHandler {
    protected int fInitialDragPixel;
    protected Point fInitialDragPosition;
    protected final ScrollBar fScrollBar;
    private boolean fMouseNearScrollScrollBar;
    protected ScrollBarPositions fScrollBarPositions;
    protected Rectangle fHandleDrawnRect;
    protected IScrollBarSettings fScrollBarSettings;
    private boolean fVisible = true;
    private final boolean fInitialVisible;

    protected AbstractScrollHandler(ScrollBar scrollBar, IScrollBarSettings scrollBarSettings) {
        this.fScrollBar = scrollBar;
        boolean initialVisible = true;
        if (scrollBar != null) {
            initialVisible = scrollBar.getVisible();
        }
        this.fInitialVisible = initialVisible;
        this.fScrollBarSettings = scrollBarSettings;
    }

    public void install(AbstractThemedScrollBarAdapter abstractThemedScrollBarAdapter) {
        if (this.fScrollBar != null) {
            this.fScrollBar.setVisible(false);
            this.fScrollBar.addSelectionListener((SelectionListener)abstractThemedScrollBarAdapter);
        }
    }

    public void uninstall(AbstractThemedScrollBarAdapter abstractThemedScrollBarAdapter, boolean disposing) {
        this.fInitialDragPosition = null;
        this.fScrollBarPositions = null;
        this.fHandleDrawnRect = null;
        if (this.fScrollBar != null && !this.fScrollBar.isDisposed() && !disposing) {
            this.fScrollBar.removeSelectionListener((SelectionListener)abstractThemedScrollBarAdapter);
            this.fScrollBar.setVisible(this.fInitialVisible);
        }
    }

    public void setVisible(boolean visible) {
        this.fVisible = visible;
    }

    public boolean getVisible() {
        return this.fVisible;
    }

    public Rectangle getHandleRect() {
        return this.fHandleDrawnRect;
    }

    public abstract Rectangle computeProximityRect(Rectangle var1);

    protected void checkScrollbarInvisible() {
    }

    protected abstract Rectangle getFullBackgroundRect(Scrollable var1, Rectangle var2, boolean var3);

    public boolean startDragOnMouseDown(Scrollable scrollable, Point controlPos, Point currHorizontalAndTopPixel, Rectangle currClientArea) {
        if (this.fScrollBar == null || !this.fVisible || !this.fScrollBarSettings.getScrollBarThemed()) {
            return false;
        }
        Rectangle rect = this.getHandleRect();
        if (rect != null && rect.contains(controlPos.x, controlPos.y)) {
            this.fInitialDragPosition = new Point(controlPos.x, controlPos.y);
            this.fInitialDragPixel = this.getRelevantPositionFromPos(currHorizontalAndTopPixel);
            return true;
        }
        return false;
    }

    public boolean scrollOnMouseDown(Scrollable scrollable, Point controlPos, Rectangle currClientArea) {
        if (this.fScrollBar == null || !this.fVisible || this.fScrollBarPositions == null || !this.fScrollBarSettings.getScrollBarThemed()) {
            return false;
        }
        Rectangle rect = this.getHandleRect();
        if (rect != null && rect.contains(controlPos.x, controlPos.y)) {
            return false;
        }
        Rectangle fullRect = this.getFullBackgroundRect(scrollable, currClientArea, true);
        if (fullRect != null && fullRect.contains(controlPos.x, controlPos.y)) {
            int pos = this.getRelevantPositionFromPos(controlPos);
            pos = (int)this.fScrollBarPositions.convertFromScrollBarPosToControlPixel(pos);
            int selection = this.fScrollBar.getSelection();
            int pageIncrement = this.fScrollBar.getPageIncrement();
            if (pos > selection) {
                this.fScrollBar.setSelection(selection + pageIncrement);
                this.notifyScrollbarSelectionChanged(scrollable, 0x1000006);
            } else {
                this.fScrollBar.setSelection(selection - pageIncrement);
                this.notifyScrollbarSelectionChanged(scrollable, 0x1000005);
            }
            return true;
        }
        return false;
    }

    public boolean mousePosOverScroll(Scrollable scrollable, Point controlPos) {
        if (this.fScrollBar == null || !this.fVisible || this.fScrollBarPositions == null || !this.fScrollBarSettings.getScrollBarThemed()) {
            return false;
        }
        Rectangle currClientArea = scrollable.getClientArea();
        Rectangle fullRect = this.getFullBackgroundRect(scrollable, currClientArea, true);
        if (fullRect != null) {
            boolean ret = fullRect.contains(controlPos.x, controlPos.y);
            return ret;
        }
        return false;
    }

    protected abstract int getRelevantPositionFromPos(Point var1);

    public boolean isDragging() {
        return this.fInitialDragPosition != null;
    }

    public boolean stopDragOnMouseUp(Scrollable scrollable) {
        if (this.fInitialDragPosition != null) {
            this.fInitialDragPosition = null;
            return true;
        }
        return false;
    }

    protected abstract void setPixel(Scrollable var1, int var2);

    public boolean dragOnMouseMove(Scrollable scrollable, Point mousePos) {
        if (this.fInitialDragPosition != null && this.fScrollBarPositions != null && this.fScrollBar != null) {
            int currentMousePos = this.getRelevantPositionFromPos(mousePos);
            int initialMousePos = this.getRelevantPositionFromPos(this.fInitialDragPosition);
            int delta = currentMousePos - initialMousePos;
            delta = (int)((double)delta / this.fScrollBarPositions.fPercentageOfClientAreaFromTotalArea);
            this.setPixel(scrollable, this.fInitialDragPixel + delta);
            this.notifyScrollbarSelectionChanged(scrollable, 1);
            return true;
        }
        return false;
    }

    protected void notifyScrollbarSelectionChanged(Scrollable scrollable, int detail) {
        Event e = new Event();
        e.type = 13;
        e.x = 0;
        e.y = 0;
        e.button = 0;
        e.stateMask = 0;
        e.count = 1;
        e.display = scrollable.getDisplay();
        e.widget = this.fScrollBar;
        e.time = 0;
        e.data = null;
        e.character = '\u0000';
        e.detail = detail;
        e.doit = true;
        this.fScrollBar.notifyListeners(13, e);
    }

    public void paintControl(GC gc, Rectangle currClientArea, Scrollable scrollable) {
        this.checkScrollbarInvisible();
        this.doPaintControl(gc, currClientArea, scrollable);
    }

    public abstract boolean computePositions(Rectangle var1, Scrollable var2);

    protected abstract void doPaintControl(GC var1, Rectangle var2, Scrollable var3);

    public int getMouseNearScrollScrollBarWidth() {
        return this.fScrollBarSettings.getMouseNearScrollScrollBarWidth();
    }

    public int getCurrentScrollBarWidth() {
        if (this.fMouseNearScrollScrollBar) {
            return this.getMouseNearScrollScrollBarWidth();
        }
        return this.fScrollBarSettings.getScrollBarWidth();
    }

    public void setCursorNearScroll(boolean cursorNearScroll) {
        this.fMouseNearScrollScrollBar = cursorNearScroll;
    }

    public boolean getMouseNearScrollScrollBar() {
        return this.fMouseNearScrollScrollBar;
    }
}

