/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.PopulationLabelValue;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabel;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationInitializer;
import org.eclipse.stem.populationmodels.standard.impl.Messages;
import org.eclipse.stem.populationmodels.standard.impl.PopulationInitializerImpl;

public class StandardPopulationInitializerImpl
extends PopulationInitializerImpl
implements StandardPopulationInitializer {
    protected static final double INDIVIDUALS_EDEFAULT = 1.0;
    protected double individuals = 1.0;
    protected static final boolean USE_DENSITY_EDEFAULT = false;
    protected boolean useDensity = false;
    protected static final String TARGET_ISO_KEY_EDEFAULT = null;
    protected String targetISOKey = TARGET_ISO_KEY_EDEFAULT;
    protected static final URI TARGET_URI_EDEFAULT = null;
    protected URI targetURI = TARGET_URI_EDEFAULT;

    public void prepare(Model model, STEMTime time) {
    }

    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        URI newURI;
        Iterator g;
        PopulationLabel newLabel;
        PopulationLabel existingLabel;
        if (this.isGraphDecorated()) {
            return;
        }
        this.checkPopulationModels();
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Node> negativeNodes = new ArrayList<Node>();
        this.getNodes(this.getGraph(), this.getTargetISOKey(), nodes, negativeNodes);
        if (nodes.size() == 0) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.StandardPopulationInitializerImpl_ERR_POP_INIT_NODE_NOT_FOUND, (Object[])new Object[]{this.getURI().toString(), this.getTargetISOKey()}), (Identifiable)this, new Exception());
        }
        for (Node n : nodes) {
            existingLabel = null;
            for (NodeLabel lab : n.getLabels()) {
                if (!(lab instanceof PopulationLabel) || !((PopulationLabel)lab).getPopulationIdentifier().equals(this.getPopulationIdentifier())) continue;
                existingLabel = (PopulationLabel)lab;
            }
            if (existingLabel != null) {
                this.initializeLabel(existingLabel, time, false);
                continue;
            }
            newLabel = LabelsFactory.eINSTANCE.createPopulationLabel();
            newLabel.setPopulationIdentifier(this.getPopulationIdentifier());
            newLabel.setURIOfIdentifiableToBeLabeled(n.getURI());
            newLabel.setNode(n);
            g = this.getGraph();
            newURI = this.createPopulationLabelURI(n, time);
            g.getNodeLabels().put((Object)newURI, (Object)newLabel);
            this.initializeLabel(newLabel, time, false);
        }
        for (Node n : negativeNodes) {
            existingLabel = null;
            for (NodeLabel lab : n.getLabels()) {
                if (!(lab instanceof PopulationLabel) || !((PopulationLabel)lab).getPopulationIdentifier().equals(this.getPopulationIdentifier())) continue;
                existingLabel = (PopulationLabel)lab;
            }
            if (existingLabel != null) continue;
            newLabel = LabelsFactory.eINSTANCE.createPopulationLabel();
            newLabel.setPopulationIdentifier(this.getPopulationIdentifier());
            newLabel.setURIOfIdentifiableToBeLabeled(n.getURI());
            newLabel.setNode(n);
            g = this.getGraph();
            newURI = this.createPopulationLabelURI(n, time);
            g.getNodeLabels().put((Object)newURI, (Object)newLabel);
            this.initializeLabel(newLabel, time, true);
        }
    }

    protected void getNodes(Graph g, String key, ArrayList<Node> list, ArrayList<Node> negList) {
        ArrayList<StandardPopulationInitializer> lowerLevelInitializers = new ArrayList<StandardPopulationInitializer>();
        for (Decorator d : g.getDecorators()) {
            if (!(d instanceof StandardPopulationInitializer) || !((StandardPopulationInitializer)d).getPopulationIdentifier().equals(this.getPopulationIdentifier()) || Utility.keyLevel((String)((StandardPopulationInitializer)d).getTargetISOKey()) <= Utility.keyLevel((String)key)) continue;
            lowerLevelInitializers.add((StandardPopulationInitializer)d);
        }
        for (Node n : g.getNodes().values()) {
            boolean foundSubInitializer = false;
            for (StandardPopulationInitializer spi : lowerLevelInitializers) {
                if (!this.isSelfOrHasParent(n, spi.getTargetISOKey())) continue;
                foundSubInitializer = true;
                break;
            }
            if (foundSubInitializer) continue;
            if ((key == null || key.trim().equals("")) && this.isLeaf(n)) {
                list.add(n);
                continue;
            }
            if (n.getURI().lastSegment().equals(key) && this.isLeaf(n)) {
                list.add(n);
                continue;
            }
            if (this.hasParent(n, key) && this.isLeaf(n)) {
                list.add(n);
                continue;
            }
            if (!this.isLeaf(n)) continue;
            negList.add(n);
        }
    }

    public boolean isLeaf(Node n) {
        for (Edge e : n.getEdges()) {
            if (!(e.getLabel() instanceof RelativePhysicalRelationshipLabel) || !e.getA().equals(n)) continue;
            return false;
        }
        return true;
    }

    public boolean hasParent(Node n, String key) {
        for (Edge e : n.getEdges()) {
            boolean phys = e.getLabel() instanceof RelativePhysicalRelationshipLabel;
            if (!phys) continue;
            if (e.getA().getURI().lastSegment().equals(key)) {
                return true;
            }
            if (Utility.keyLevel((String)e.getA().getURI().lastSegment()) >= Utility.keyLevel((String)n.getURI().lastSegment())) continue;
            return this.hasParent(e.getA(), key);
        }
        return false;
    }

    public boolean isSelfOrHasParent(Node n, String key) {
        if (n.getURI().lastSegment().equals(key)) {
            return true;
        }
        return this.hasParent(n, key);
    }

    @Override
    protected void initializeLabel(PopulationLabel lab, STEMTime time, boolean zeroValue) throws ScenarioInitializationException {
        if (this.isUseDensity()) {
            PopulationLabelValue plv;
            Node n = lab.getNode();
            if (n == null) {
                throw new ScenarioInitializationException(NLS.bind((String)Messages.StandardPopulationInitializerImpl_CANNOT_INIT_POPULATION, (Object[])new Object[]{this.getPopulationIdentifier(), lab.toString()}), (Identifiable)this, new Exception());
            }
            double area = 0.0;
            for (NodeLabel l : n.getLabels()) {
                if (!(l instanceof AreaLabel)) continue;
                area = ((AreaLabel)l).getCurrentAreaValue().getArea();
                break;
            }
            if (area == 0.0) {
                if (!n.getURI().toString().contains("/transport/pipe")) {
                    throw new ScenarioInitializationException(NLS.bind((String)Messages.StandardPopulationInitializerImpl_UNABLE_TO_FIND_AREA, (Object[])new Object[]{n.getURI().toString(), this.getURI().toString()}), (Identifiable)this, new Exception());
                }
                plv = lab.getCurrentPopulationValue();
                if (!zeroValue) {
                    plv.setCount(this.getIndividuals());
                } else {
                    plv.setCount(0.0);
                }
            } else {
                plv = lab.getCurrentPopulationValue();
                if (!zeroValue) {
                    plv.setCount(this.getIndividuals() * area);
                } else {
                    plv.setCount(0.0);
                }
            }
        } else {
            PopulationLabelValue plv = lab.getCurrentPopulationValue();
            if (!zeroValue) {
                plv.setCount(this.getIndividuals());
            } else {
                plv.setCount(0.0);
            }
        }
        lab.setValidYear(this.getYear(time));
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STANDARD_POPULATION_INITIALIZER;
    }

    @Override
    public double getIndividuals() {
        return this.individuals;
    }

    @Override
    public void setIndividuals(double newIndividuals) {
        this.individuals = newIndividuals;
    }

    @Override
    public boolean isUseDensity() {
        return this.useDensity;
    }

    @Override
    public void setUseDensity(boolean newUseDensity) {
        this.useDensity = newUseDensity;
    }

    @Override
    public String getTargetISOKey() {
        return this.targetISOKey;
    }

    @Override
    public void setTargetISOKey(String newTargetISOKey) {
        this.targetISOKey = newTargetISOKey;
    }

    @Override
    public URI getTargetURI() {
        return this.targetURI;
    }

    @Override
    public void setTargetURI(URI newTargetURI) {
        this.targetURI = newTargetURI;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getIndividuals();
            }
            case 10: {
                return this.isUseDensity();
            }
            case 11: {
                return this.getTargetISOKey();
            }
            case 12: {
                return this.getTargetURI();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setIndividuals((Double)newValue);
                return;
            }
            case 10: {
                this.setUseDensity((Boolean)newValue);
                return;
            }
            case 11: {
                this.setTargetISOKey((String)newValue);
                return;
            }
            case 12: {
                this.setTargetURI((URI)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setIndividuals(1.0);
                return;
            }
            case 10: {
                this.setUseDensity(false);
                return;
            }
            case 11: {
                this.setTargetISOKey(TARGET_ISO_KEY_EDEFAULT);
                return;
            }
            case 12: {
                this.setTargetURI(TARGET_URI_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.individuals != 1.0;
            }
            case 10: {
                return this.useDensity;
            }
            case 11: {
                return TARGET_ISO_KEY_EDEFAULT == null ? this.targetISOKey != null : !TARGET_ISO_KEY_EDEFAULT.equals(this.targetISOKey);
            }
            case 12: {
                return TARGET_URI_EDEFAULT == null ? this.targetURI != null : !TARGET_URI_EDEFAULT.equals(this.targetURI);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (individuals: ");
        result.append(this.individuals);
        result.append(", useDensity: ");
        result.append(this.useDensity);
        result.append(", targetISOKey: ");
        result.append(this.targetISOKey);
        result.append(", targetURI: ");
        result.append(this.targetURI);
        result.append(')');
        return result.toString();
    }
}

