/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.diseasemodels.experimental.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.experimental.provider.ExperimentalItemProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.experimental.util.ExperimentalAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.ui.IStartup;

public class ExperimentalRelativeValueProviderAdapterFactory
extends ExperimentalAdapterFactory
implements RelativeValueProviderAdapterFactory,
IStartup {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    private static ExperimentalItemProviderAdapterFactory itemProviderFactory;

    public ExperimentalRelativeValueProviderAdapterFactory() {
        RelativeValueProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    public Adapter createTBDiseaseModelLabelValueAdapter() {
        return new ExperimentalDiseaseModelLabelValueRelativeValueProvider();
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return type == RelativeValueProvider.class || super.isFactoryForType(type);
    }

    public void dispose() {
    }

    private static RelativeValueProviderAdapterFactory getRelativeValueProviderAdapterFactory() {
        return RelativeValueProviderAdapterFactory.INSTANCE;
    }

    public void earlyStartup() {
    }

    private static ExperimentalItemProviderAdapterFactory getItemProviderFactory() {
        if (itemProviderFactory == null) {
            itemProviderFactory = new ExperimentalItemProviderAdapterFactory();
        }
        return itemProviderFactory;
    }

    public static class ExperimentalDiseaseModelLabelValueRelativeValueProvider
    extends RelativeValueProviderAdapter
    implements RelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            ArrayList<IItemPropertyDescriptor> retValue = new ArrayList<IItemPropertyDescriptor>();
            ExperimentalItemProviderAdapterFactory itemProviderFactory = ExperimentalRelativeValueProviderAdapterFactory.getItemProviderFactory();
            DiseaseModelLabelValue dmlv = (DiseaseModelLabelValue)this.getTarget();
            IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)dmlv, PropertySource.class);
            List properties = propertySource.getPropertyDescriptors(null);
            for (IItemPropertyDescriptor descriptor : properties) {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                if (feature instanceof EReference) continue;
                retValue.add(descriptor);
            }
            return retValue;
        }

        public double getRelativeValue(EStructuralFeature feature) {
            DiseaseModelLabelValue dmlv = (DiseaseModelLabelValue)this.getTarget();
            double stateCount = (Double)dmlv.eGet(feature);
            double populationCount = dmlv.getPopulationCount();
            double retValue = populationCount <= 0.0 ? 0.0 : stateCount / populationCount;
            return retValue;
        }

        public double getDenominator(EStructuralFeature feature) {
            DiseaseModelLabelValue dmlv = (DiseaseModelLabelValue)this.getTarget();
            return dmlv.getPopulationCount();
        }
    }
}

