/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.populationmodels.standard.StandardFactory;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.PopulationModelLabelValueImpl;

public class StandardPopulationModelLabelValueImpl
extends PopulationModelLabelValueImpl
implements StandardPopulationModelLabelValue {
    protected static final double COUNT_EDEFAULT = 0.0;
    protected double count = 0.0;
    protected static final double BIRTHS_EDEFAULT = 0.0;
    protected double births = 0.0;
    protected static final double DEATHS_EDEFAULT = 0.0;
    protected double deaths = 0.0;
    protected static final double DENSITY_EDEFAULT = 0.0;
    protected double density = 0.0;

    protected StandardPopulationModelLabelValueImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STANDARD_POPULATION_MODEL_LABEL_VALUE;
    }

    @Override
    public double getCount() {
        return this.count;
    }

    @Override
    public void setCount(double newCount) {
        this.count = newCount;
    }

    @Override
    public double getBirths() {
        return this.births;
    }

    @Override
    public void setBirths(double newBirths) {
        this.births = newBirths;
    }

    @Override
    public double getDeaths() {
        return this.deaths;
    }

    @Override
    public void setDeaths(double newDeaths) {
        this.deaths = newDeaths;
    }

    @Override
    public double getDensity() {
        Node n;
        double population = this.getCount();
        double area = 0.0;
        StandardPopulationModelLabel label = (StandardPopulationModelLabel)this.eContainer();
        if (label != null && (n = label.getNode()) != null && n.getLabels() != null) {
            for (NodeLabel nodeLab : n.getLabels()) {
                if (!(nodeLab instanceof AreaLabel)) continue;
                area = ((AreaLabel)nodeLab).getCurrentAreaValue().getArea();
                break;
            }
        }
        return area > 0.0 ? population / area : 0.0;
    }

    public boolean isSetDensity() {
        return true;
    }

    public boolean avoidNegative(IntegrationLabelValue value) {
        StandardPopulationModelLabelValue sval = (StandardPopulationModelLabelValue)value;
        boolean adjusted = false;
        double newCount = this.getCount() + sval.getCount();
        double newBirths = this.getBirths() + sval.getBirths();
        double newDeaths = this.getDeaths() + sval.getDeaths();
        if (newCount < 0.0) {
            adjusted = true;
            this.setCount(-sval.getCount());
        }
        if (newBirths < 0.0) {
            adjusted = true;
            this.setBirths(-sval.getBirths());
        }
        if (newDeaths < 0.0) {
            adjusted = true;
            this.setDeaths(-sval.getDeaths());
        }
        return adjusted;
    }

    public double computeDeltaAdjustment(IntegrationLabelValue value) {
        StandardPopulationModelLabelValue sval = (StandardPopulationModelLabelValue)value;
        double newCount = this.getCount() + sval.getCount();
        double newBirths = this.getBirths() + sval.getBirths();
        double newDeaths = this.getDeaths() + sval.getDeaths();
        double factor = 1.0;
        if (newCount < 0.0) {
            factor = Math.min(factor, -sval.getCount() / this.getCount());
        }
        if (newBirths < 0.0) {
            factor = Math.min(factor, -sval.getBirths() / this.getBirths());
        }
        if (newDeaths < 0.0) {
            factor = Math.min(factor, -sval.getDeaths() / this.getDeaths());
        }
        return factor;
    }

    public boolean sameValue(LabelValue otherValue) {
        if (!(otherValue instanceof StandardPopulationModelLabelValue)) {
            return false;
        }
        return ((StandardPopulationModelLabelValue)otherValue).getCount() == this.getCount() && ((StandardPopulationModelLabelValue)otherValue).getDeaths() == this.getDeaths();
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getCount();
            }
            case 3: {
                return this.getBirths();
            }
            case 4: {
                return this.getDeaths();
            }
            case 5: {
                return this.getDensity();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setCount((Double)newValue);
                return;
            }
            case 3: {
                this.setBirths((Double)newValue);
                return;
            }
            case 4: {
                this.setDeaths((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setCount(0.0);
                return;
            }
            case 3: {
                this.setBirths(0.0);
                return;
            }
            case 4: {
                this.setDeaths(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.count != 0.0;
            }
            case 3: {
                return this.births != 0.0;
            }
            case 4: {
                return this.deaths != 0.0;
            }
            case 5: {
                return this.density != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer();
        result.append(" (count: ");
        result.append(this.getCount());
        result.append(", births: ");
        result.append(this.getBirths());
        result.append(", deaths: ");
        result.append(this.getDeaths());
        result.append(')');
        return result.toString();
    }

    public IntegrationLabelValue abs() {
        this.setCount(Math.abs(this.getCount()));
        this.setBirths(Math.abs(this.getBirths()));
        this.setDeaths(Math.abs(this.getDeaths()));
        return this;
    }

    public IntegrationLabelValue add(IntegrationLabelValue value) {
        StandardPopulationModelLabelValue v = (StandardPopulationModelLabelValue)value;
        this.setBirths(this.getBirths() + v.getBirths());
        this.setDeaths(this.getDeaths() + v.getDeaths());
        this.setCount(this.getCount() + v.getCount());
        return this;
    }

    public IntegrationLabelValue add(double addition) {
        this.setCount(this.getCount() + addition);
        this.setBirths(this.getBirths() + addition);
        this.setDeaths(this.getDeaths() + addition);
        return this;
    }

    public IntegrationLabelValue scale(double scaleFactor) {
        this.setCount(this.getCount() * scaleFactor);
        this.setBirths(this.getBirths() * scaleFactor);
        this.setDeaths(this.getDeaths() * scaleFactor);
        return this;
    }

    public IntegrationLabelValue set(IntegrationLabelValue value) {
        StandardPopulationModelLabelValue v = (StandardPopulationModelLabelValue)value;
        this.setCount(v.getCount());
        this.setBirths(v.getBirths());
        this.setDeaths(v.getDeaths());
        return this;
    }

    public IntegrationLabelValue sub(IntegrationLabelValue value) {
        StandardPopulationModelLabelValue v = (StandardPopulationModelLabelValue)value;
        this.setBirths(this.getBirths() - v.getBirths());
        this.setDeaths(this.getDeaths() - v.getDeaths());
        this.setCount(this.getCount() - v.getCount());
        return this;
    }

    public IntegrationLabelValue divide(IntegrationLabelValue d) {
        StandardPopulationModelLabelValue _scale = (StandardPopulationModelLabelValue)d;
        double cScaled = Math.abs(this.getCount()) / Math.abs(_scale.getCount());
        double bScaled = Math.abs(this.getBirths()) / Math.abs(_scale.getBirths());
        double dScaled = Math.abs(this.getDeaths()) / Math.abs(_scale.getDeaths());
        this.setCount(cScaled);
        this.setBirths(bScaled);
        this.setDeaths(dScaled);
        return this;
    }

    public double max() {
        if (this.getCount() > this.getBirths() && this.getCount() > this.getDeaths()) {
            return this.getCount();
        }
        if (this.getBirths() > this.getDeaths()) {
            return this.getBirths();
        }
        return this.getDeaths();
    }

    public IntegrationLabelValue copy() {
        StandardPopulationModelLabelValue ilv = StandardFactory.eINSTANCE.createStandardPopulationModelLabelValue();
        ilv.set(this);
        return ilv;
    }

    @Override
    public void eSetDouble(int featureId, double newValue) {
        switch (featureId) {
            case 2: {
                this.setCount(newValue);
                return;
            }
            case 3: {
                this.setBirths(newValue);
                return;
            }
            case 4: {
                this.setDeaths(newValue);
                return;
            }
        }
        super.eSetDouble(featureId, newValue);
    }

    @Override
    public double eGetDouble(int featureId) {
        switch (featureId) {
            case 2: {
                return this.getCount();
            }
            case 3: {
                return this.getBirths();
            }
            case 4: {
                return this.getDeaths();
            }
            case 5: {
                return this.getDensity();
            }
        }
        return super.eGetDouble(featureId);
    }

    public void reset() {
        super.reset();
        this.setCount(0.0);
        this.setBirths(0.0);
        this.setDeaths(0.0);
        this.arrivals = null;
        this.departures = null;
    }

    public void prepareCycle() {
    }
}

