/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.impl.DynamicEdgeLabelImpl;
import org.eclipse.stem.core.graph.impl.EdgeImpl;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.EdgeDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.LabelsPackage;
import org.eclipse.stem.definitions.labels.TransportMode;
import org.eclipse.stem.definitions.labels.TransportRelationshipLabel;
import org.eclipse.stem.definitions.labels.TransportRelationshipLabelValue;

public class TransportRelationshipLabelImpl
extends DynamicEdgeLabelImpl
implements TransportRelationshipLabel {
    protected static final TransportMode TRANSPORT_MODE_EDEFAULT = TransportMode.UNSPECIFIED_LITERAL;
    protected TransportMode transportMode = TRANSPORT_MODE_EDEFAULT;
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = null;
    protected String populationIdentifier = POPULATION_IDENTIFIER_EDEFAULT;
    protected static final String TRANSPORT_IDENTIFIER_EDEFAULT = null;
    protected String transportIdentifier = TRANSPORT_IDENTIFIER_EDEFAULT;
    protected static final long RATE_TIME_PERIOD_EDEFAULT = 0L;
    protected long rateTimePeriod = 0L;
    protected static final int DEPARTURE_CAPACITY_EDEFAULT = 0;
    protected static final int MAXIMUM_DEPARTURE_CAPACITY_EDEFAULT = 0;
    protected int maximumDepartureCapacity = 0;
    protected static final int CAPACITY_EDEFAULT = 0;
    protected static final int MAXIMUM_CAPACITY_EDEFAULT = 0;
    protected int maximumCapacity = 0;
    protected static final long TRANSIT_TIME_EDEFAULT = 0L;
    protected long transitTime = 0L;
    protected static final long START_UP_DELAY_EDEFAULT = 0L;
    protected long startUpDelay = 0L;
    private EObject nodeBArrivals = null;
    private EObject nodeAArrivals = null;

    protected TransportRelationshipLabelImpl() {
        this.setCurrentValue(LabelsFactory.eINSTANCE.createTransportRelationshipLabelValue());
        this.setNextValue(LabelsFactory.eINSTANCE.createTransportRelationshipLabelValue());
    }

    public static Edge createTransportRelationship(Node nodeA, Node nodeB, TransportMode transportMode, String transportIdentifier, String populationIdentifier, long rateTimePeriod, int maximumCapacity, EdgeDecorator edgeDecorator) {
        return TransportRelationshipLabelImpl.createTransportRelationship(nodeA, nodeB, transportMode, transportIdentifier, populationIdentifier, rateTimePeriod, maximumCapacity, false, edgeDecorator);
    }

    public static Edge createTransportRelationship(Node nodeA, Node nodeB, TransportMode transportMode, String transportIdentifier, String populationIdentifier, long rateTimePeriod, int maximumCapacity, boolean directed, EdgeDecorator edgeDecorator) {
        return TransportRelationshipLabelImpl.createTransportRelationship(nodeA, nodeB, transportMode, transportIdentifier, populationIdentifier, rateTimePeriod, maximumCapacity, maximumCapacity, 0L, 0L, directed, edgeDecorator);
    }

    public static Edge createTransportRelationship(Node nodeA, Node nodeB, TransportMode transportMode, String transportIdentifier, String populationIdentifier, long rateTimePeriod, int maximumDepartureCapacity, int maximumCapacity, long transitTime, long startUpDelay, EdgeDecorator edgeDecorator) {
        return TransportRelationshipLabelImpl.createTransportRelationship(nodeA, nodeB, transportMode, transportIdentifier, populationIdentifier, rateTimePeriod, maximumDepartureCapacity, maximumCapacity, transitTime, startUpDelay, false, edgeDecorator);
    }

    public static Edge createTransportRelationship(Node nodeA, Node nodeB, TransportMode transportMode, String transportIdentifier, String populationIdentifier, long rateTimePeriod, int maximumDepartureCapacity, int maximumCapacity, long transitTime, long startUpDelay, boolean directed, EdgeDecorator edgeDecorator) {
        Edge retValue = EdgeImpl.createEdge((Node)nodeA, (Node)nodeB, (boolean)directed);
        TransportRelationshipLabel label = LabelsFactory.eINSTANCE.createTransportRelationshipLabel();
        label.setURIOfIdentifiableToBeLabeled(retValue.getURI());
        label.setDecorator((Decorator)edgeDecorator);
        label.setPopulationIdentifier(populationIdentifier);
        label.setTransportIdentifier(transportIdentifier);
        label.setRateTimePeriod(rateTimePeriod);
        label.setMaximumDepartureCapacity(maximumDepartureCapacity);
        label.setMaximumCapacity(maximumCapacity);
        label.setTransitTime(transitTime);
        label.setStartUpDelay(startUpDelay);
        label.setTransportMode(transportMode);
        TransportRelationshipLabelValue trlv = label.getCurrentTransportRelationshipLabelValue();
        trlv.setAvailableDepartureCapacityProportion(1.0);
        retValue.setLabel((EdgeLabel)label);
        return retValue;
    }

    protected EClass eStaticClass() {
        return LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL;
    }

    @Override
    public TransportMode getTransportMode() {
        return this.transportMode;
    }

    @Override
    public void setTransportMode(TransportMode newTransportMode) {
        TransportMode oldTransportMode = this.transportMode;
        TransportMode transportMode = this.transportMode = newTransportMode == null ? TRANSPORT_MODE_EDEFAULT : newTransportMode;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldTransportMode, (Object)this.transportMode));
        }
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String newPopulationIdentifier) {
        String oldPopulationIdentifier = this.populationIdentifier;
        this.populationIdentifier = newPopulationIdentifier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldPopulationIdentifier, (Object)this.populationIdentifier));
        }
    }

    @Override
    public String getTransportIdentifier() {
        return this.transportIdentifier;
    }

    @Override
    public void setTransportIdentifier(String newTransportIdentifier) {
        String oldTransportIdentifier = this.transportIdentifier;
        this.transportIdentifier = newTransportIdentifier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldTransportIdentifier, (Object)this.transportIdentifier));
        }
    }

    @Override
    public TransportRelationshipLabelValue getCurrentTransportRelationshipLabelValue() {
        return (TransportRelationshipLabelValue)this.getCurrentValue();
    }

    @Override
    public long getRateTimePeriod() {
        return this.rateTimePeriod;
    }

    @Override
    public void setRateTimePeriod(long newRateTimePeriod) {
        long oldRateTimePeriod = this.rateTimePeriod;
        this.rateTimePeriod = newRateTimePeriod;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldRateTimePeriod, this.rateTimePeriod));
        }
    }

    @Override
    public int getDepartureCapacity() {
        return (int)((double)this.getMaximumDepartureCapacity() * this.getCurrentTransportRelationshipLabelValue().getAvailableDepartureCapacityProportion());
    }

    @Override
    public int getMaximumDepartureCapacity() {
        return this.maximumDepartureCapacity;
    }

    @Override
    public void setMaximumDepartureCapacity(int newMaximumDepartureCapacity) {
        int oldMaximumDepartureCapacity = this.maximumDepartureCapacity;
        this.maximumDepartureCapacity = newMaximumDepartureCapacity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldMaximumDepartureCapacity, this.maximumDepartureCapacity));
        }
    }

    @Override
    public int getCapacity() {
        return (int)((double)this.getMaximumCapacity() * this.getCurrentTransportRelationshipLabelValue().getAvailableDepartureCapacityProportion());
    }

    @Override
    public int getMaximumCapacity() {
        return this.maximumCapacity;
    }

    @Override
    public void setMaximumCapacity(int newMaximumCapacity) {
        int oldMaximumCapacity = this.maximumCapacity;
        this.maximumCapacity = newMaximumCapacity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, oldMaximumCapacity, this.maximumCapacity));
        }
    }

    @Override
    public long getTransitTime() {
        return this.transitTime;
    }

    @Override
    public void setTransitTime(long newTransitTime) {
        long oldTransitTime = this.transitTime;
        this.transitTime = newTransitTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, oldTransitTime, this.transitTime));
        }
    }

    @Override
    public long getStartUpDelay() {
        return this.startUpDelay;
    }

    @Override
    public void setStartUpDelay(long newStartUpDelay) {
        long oldStartUpDelay = this.startUpDelay;
        this.startUpDelay = newStartUpDelay;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, oldStartUpDelay, this.startUpDelay));
        }
    }

    @Override
    public void send(Node here, EObject departees) {
        if (this.getEdge().getA().equals(here)) {
            this.nodeBArrivals = departees;
        } else {
            this.nodeAArrivals = departees;
        }
    }

    @Override
    public EList<EObject> receive(Node here, STEMTime currentTime) {
        BasicEList retValue = new BasicEList();
        if (this.getEdge().getA().equals(here)) {
            if (this.nodeAArrivals != null) {
                retValue.add((Object)this.nodeAArrivals);
                this.nodeAArrivals = null;
            }
        } else if (this.nodeBArrivals != null) {
            retValue.add((Object)this.nodeBArrivals);
            this.nodeBArrivals = null;
        }
        return retValue;
    }

    public static List<Edge> getTransportEdgesToNode(Node node, String populationIdentifier) {
        ArrayList<Edge> retValue = new ArrayList<Edge>();
        for (Edge edge : node.getEdges()) {
            TransportRelationshipLabel transportLabel;
            EdgeLabel edgeLabel;
            if (edge.isDirected() && !edge.isDirectedAt(node) || !((edgeLabel = edge.getLabel()) instanceof TransportRelationshipLabel) || !(transportLabel = (TransportRelationshipLabel)edgeLabel).getPopulationIdentifier().equalsIgnoreCase(populationIdentifier)) continue;
            retValue.add(edge);
        }
        return retValue;
    }

    public static List<Edge> getTransportEdgesFromNode(Node node, String populationIdentifier) {
        ArrayList<Edge> retValue = new ArrayList<Edge>();
        for (Edge edge : node.getEdges()) {
            TransportRelationshipLabel transportLabel;
            EdgeLabel edgeLabel;
            if (edge.isDirected() && edge.isDirectedAt(node) || !((edgeLabel = edge.getLabel()) instanceof TransportRelationshipLabel) || !(transportLabel = (TransportRelationshipLabel)edgeLabel).getPopulationIdentifier().equalsIgnoreCase(populationIdentifier)) continue;
            retValue.add(edge);
        }
        return retValue;
    }

    public void reset() {
        super.reset();
        this.nodeAArrivals = null;
        this.nodeBArrivals = null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getTransportMode();
            }
            case 11: {
                return this.getPopulationIdentifier();
            }
            case 12: {
                return this.getTransportIdentifier();
            }
            case 13: {
                return this.getCurrentTransportRelationshipLabelValue();
            }
            case 14: {
                return this.getRateTimePeriod();
            }
            case 15: {
                return this.getDepartureCapacity();
            }
            case 16: {
                return this.getMaximumDepartureCapacity();
            }
            case 17: {
                return this.getCapacity();
            }
            case 18: {
                return this.getMaximumCapacity();
            }
            case 19: {
                return this.getTransitTime();
            }
            case 20: {
                return this.getStartUpDelay();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setTransportMode((TransportMode)((Object)newValue));
                return;
            }
            case 11: {
                this.setPopulationIdentifier((String)newValue);
                return;
            }
            case 12: {
                this.setTransportIdentifier((String)newValue);
                return;
            }
            case 14: {
                this.setRateTimePeriod((Long)newValue);
                return;
            }
            case 16: {
                this.setMaximumDepartureCapacity((Integer)newValue);
                return;
            }
            case 18: {
                this.setMaximumCapacity((Integer)newValue);
                return;
            }
            case 19: {
                this.setTransitTime((Long)newValue);
                return;
            }
            case 20: {
                this.setStartUpDelay((Long)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setTransportMode(TRANSPORT_MODE_EDEFAULT);
                return;
            }
            case 11: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
            case 12: {
                this.setTransportIdentifier(TRANSPORT_IDENTIFIER_EDEFAULT);
                return;
            }
            case 14: {
                this.setRateTimePeriod(0L);
                return;
            }
            case 16: {
                this.setMaximumDepartureCapacity(0);
                return;
            }
            case 18: {
                this.setMaximumCapacity(0);
                return;
            }
            case 19: {
                this.setTransitTime(0L);
                return;
            }
            case 20: {
                this.setStartUpDelay(0L);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.transportMode != TRANSPORT_MODE_EDEFAULT;
            }
            case 11: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
            case 12: {
                return TRANSPORT_IDENTIFIER_EDEFAULT == null ? this.transportIdentifier != null : !TRANSPORT_IDENTIFIER_EDEFAULT.equals(this.transportIdentifier);
            }
            case 13: {
                return this.getCurrentTransportRelationshipLabelValue() != null;
            }
            case 14: {
                return this.rateTimePeriod != 0L;
            }
            case 15: {
                return this.getDepartureCapacity() != 0;
            }
            case 16: {
                return this.maximumDepartureCapacity != 0;
            }
            case 17: {
                return this.getCapacity() != 0;
            }
            case 18: {
                return this.maximumCapacity != 0;
            }
            case 19: {
                return this.transitTime != 0L;
            }
            case 20: {
                return this.startUpDelay != 0L;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer();
        result.append((Object)this.getTransportMode());
        result.append(", ");
        result.append(this.getPopulationIdentifier());
        result.append(", \"");
        result.append(this.getTransportIdentifier());
        result.append("\" ");
        result.append(this.getCurrentTransportRelationshipLabelValue().toString());
        return result.toString();
    }

    public boolean sane() {
        boolean retValue = super.sane();
        boolean bl = retValue = retValue && this.getRateTimePeriod() >= 0L;
        assert (retValue);
        retValue = retValue && this.getCurrentTransportRelationshipLabelValue().sane();
        return retValue;
    }
}

