/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;

public class RemoveUnsupportedAnnotationOperation
extends UIJob {
    private IMarker[] fMarkers = null;

    public RemoveUnsupportedAnnotationOperation(IMarker[] markers) {
        super(MarkerMessages.RemoveUnsupportedAnnotationOperation_remove_unsupported_annotations);
        this.fMarkers = markers;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MarkerMessages.RemoveUnsupportedTagOperation_removeing_unsupported_tag, (int)(this.fMarkers.length + 6));
        HashMap<ICompilationUnit, Boolean> seen = new HashMap<ICompilationUnit, Boolean>();
        IMarker[] iMarkerArray = this.fMarkers;
        int n = this.fMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker fMarker = iMarkerArray[n2];
            IResource resource = fMarker.getResource();
            IJavaElement javaElement = JavaCore.create((IResource)resource);
            try {
                if (javaElement != null && javaElement.getElementType() == 5) {
                    ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                    if (!seen.containsKey(compilationUnit)) {
                        seen.put(compilationUnit, compilationUnit.hasUnsavedChanges());
                    }
                    if (!compilationUnit.isWorkingCopy()) {
                        JavaUI.openInEditor((IJavaElement)compilationUnit);
                    }
                    if (!compilationUnit.isConsistent()) {
                        compilationUnit.reconcile(0, false, null, null);
                        localMonitor.split(1);
                    }
                    localMonitor.split(1);
                    ASTParser parser = ASTParser.newParser((int)10);
                    parser.setSource(compilationUnit);
                    Integer charStartAttribute = null;
                    charStartAttribute = (Integer)fMarker.getAttribute("charStart");
                    int intValue = charStartAttribute;
                    parser.setFocalPosition(intValue);
                    CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
                    AnnotationFinder finder = new AnnotationFinder(intValue);
                    unit.accept((ASTVisitor)finder);
                    localMonitor.split(1);
                    if (finder.fNode != null) {
                        unit.recordModifications();
                        AST ast = unit.getAST();
                        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                        TextEditGroup group = new TextEditGroup("Removing API tools annotations");
                        rewrite.remove((ASTNode)finder.fNode, group);
                        localMonitor.split(1);
                        TextEdit edit = rewrite.rewriteAST();
                        compilationUnit.applyTextEdit(edit, monitor);
                        localMonitor.split(1);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (PartInitException partInitException) {
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        for (Map.Entry entry : seen.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            try {
                ((ICompilationUnit)entry.getKey()).commitWorkingCopy(true, null);
            }
            catch (JavaModelException javaModelException) {}
        }
        return Status.OK_STATUS;
    }

    class AnnotationFinder
    extends ASTVisitor {
        int fPosition = -1;
        MarkerAnnotation fNode = null;
        boolean found = false;

        AnnotationFinder(int position) {
            this.fPosition = position;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return !this.found;
        }

        public boolean visit(EnumDeclaration node) {
            return !this.found;
        }

        public boolean visit(FieldDeclaration node) {
            return !this.found;
        }

        public boolean visit(MethodDeclaration node) {
            return !this.found;
        }

        public boolean visit(TypeDeclaration node) {
            return !this.found;
        }

        public boolean visit(Block node) {
            return !this.found;
        }

        public boolean visit(MarkerAnnotation node) {
            int start = node.getStartPosition();
            int end = node.getLength() - 1 + start;
            if (start <= this.fPosition && this.fPosition <= end) {
                this.fNode = node;
                this.found = true;
            }
            return false;
        }
    }
}

