/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.Coordinates;
import org.eclipse.stem.ui.ge.kml.LookAt;
import org.eclipse.stem.ui.ge.kml.NetworkLink;
import org.eclipse.stem.ui.ge.kml.PlaceMark;
import org.eclipse.stem.ui.ge.kml.Point;
import org.eclipse.stem.ui.ge.kml.Polygon;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class KmlDoc {
    private static final String _className = "KmlDoc";
    private Document _doc;

    public KmlDoc() {
        String methodName = "KmlDoc.KmlUtil(constructor) ";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = factory.newDocumentBuilder();
            if (docBuilder != null) {
                this._doc = docBuilder.newDocument();
            }
        }
        catch (ParserConfigurationException pce) {
            this.debug(String.valueOf(methodName) + " Error configuring xml document builder" + pce.getMessage());
        }
    }

    public Element setRoot(String xmlns) {
        if (xmlns == null) {
            xmlns = "http://earth.google.com/kml/2.1";
        }
        Element root = this._doc.createElement("kml");
        root.setAttribute("xmlns", xmlns);
        this._doc.appendChild(root);
        return root;
    }

    public void writeFile(String xmlFileName_) {
        try {
            FileOutputStream outputStream = new FileOutputStream(xmlFileName_);
            this.write(outputStream);
        }
        catch (Exception e) {
            this.debug(e);
        }
    }

    public void write(OutputStream os) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource docSource = new DOMSource(this._doc);
            StreamResult result = new StreamResult(os);
            transformer.transform(docSource, result);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            this.debug(e);
        }
    }

    public void display() {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource docSource = new DOMSource(this._doc);
            StreamResult result = new StreamResult(System.out);
            transformer.transform(docSource, result);
        }
        catch (Exception e) {
            this.debug(e);
        }
    }

    public void debug(String msg) {
        GELog.debug(this, msg);
    }

    public void debug(String method, String msg) {
        GELog.debug(this, String.valueOf(method) + msg);
    }

    public void debug(Throwable t) {
        GELog.error("KmlDoc failure", t);
    }

    public void debug(String msg, Throwable t) {
        GELog.error("KmlDoc: " + msg, t);
    }

    public Document getDocument() {
        return this._doc;
    }

    public void setDocument(Document _doc) {
        this._doc = _doc;
    }

    public static Element createAttr(Document doc, String tag, String value) {
        Element nm = doc.createElement(tag);
        Text t = doc.createTextNode(value);
        nm.appendChild(t);
        return nm;
    }

    public static Element createCDataAttr(Document doc, String tag, String value) {
        Element nm = doc.createElement(tag);
        CDATASection t = doc.createCDATASection(value);
        nm.appendChild(t);
        return nm;
    }

    public Element appendElement(Element element, String tag) {
        Element newtag = this._doc.createElement(tag);
        element.appendChild(newtag);
        return newtag;
    }

    public Element appendText(Element element, String tag, String value) {
        if (value.indexOf("<") >= 0 || value.indexOf(">") >= 0) {
            return this.appendCDATA(element, tag, value);
        }
        Element nm = this._doc.createElement(tag);
        Text t = this._doc.createTextNode(value);
        nm.appendChild(t);
        element.appendChild(nm);
        return nm;
    }

    public Element appendCDATA(Element element, String tag, String value) {
        Element nm = this._doc.createElement(tag);
        CDATASection cdata = this._doc.createCDATASection(value);
        nm.appendChild(cdata);
        element.appendChild(nm);
        return nm;
    }

    public Element appendAttr(Element element, String tag, boolean value) {
        Element nm = this._doc.createElement(tag);
        String strValue = value ? "1" : "0";
        Text t = this._doc.createTextNode(strValue);
        nm.appendChild(t);
        element.appendChild(nm);
        return nm;
    }

    public static void main(String[] args) {
        KmlDoc kml = new KmlDoc();
        Document doc = kml.getDocument();
        Element root = kml.setRoot(null);
        Element folderA = doc.createElement("Folder");
        root.appendChild(folderA);
        Element folderA1 = doc.createElement("Folder");
        folderA.appendChild(folderA1);
        PlaceMark placeMark = new PlaceMark(doc);
        folderA1.appendChild(placeMark.getElement());
        kml.appendText(placeMark.getElement(), "description", "Home at<br>119 Third");
        placeMark.setName("Home");
        LookAt lookat = new LookAt(doc);
        lookat.setCoordinates(-122.0059, 36.9639);
        lookat.setRange(305.8880792294568);
        lookat.setTilt(46.72425699662645);
        lookat.setHeading(49.06133439171233);
        placeMark.appendChild(lookat.getElement());
        kml.appendAttr(placeMark.getElement(), "visibility", false);
        Point point = new Point(doc);
        point.setCoordinates(-122.0059, 36.9639);
        placeMark.appendChild(point.getElement());
        Element folderA2 = doc.createElement("Folder");
        folderA.appendChild(folderA2);
        Polygon polygon = new Polygon(doc);
        Coordinates[] corners = new Coordinates[4];
        corners[0] = new Coordinates(-122.0059, 36.9639);
        corners[1] = new Coordinates(-122.0049, 36.9639);
        corners[2] = new Coordinates(-122.0049, 36.99);
        corners[2] = new Coordinates(-122.0059, 36.9639);
        polygon.setCoordinates(corners);
        folderA2.appendChild(polygon.getElement());
        Element folderA3 = doc.createElement("Folder");
        folderA.appendChild(folderA3);
        NetworkLink netLink = new NetworkLink(doc);
        String urlfile = "c:/tmp/test.kml";
        int interval = 6;
        netLink.setUrl(urlfile, interval, null);
        folderA3.appendChild(netLink.getElement());
        kml.display();
        kml.writeFile("test1.kml");
    }
}

