/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.geography.names;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.stem.data.geography.Activator;

public abstract class GeographicMapper {
    public static final String EARTH_ALPHA3_ISO_KEY = "ZZZ";
    public static final String ALPHA2_TO_ALPHA3_NAME = "level0ISOKeys.properties";
    private static final URI LEVEL_0_ISO_MAPPING_FILE_URI = URI.createURI((String)"platform:/plugin/org.eclipse.stem.data.geography/resources/data/country/ZZZ/level0ISOKeys.properties");
    protected static final String RB_PREFIX = "org.eclipse.stem.data.geography";
    private static Properties alpha2ToAlpha3Map = null;
    private static Properties alpha3ToAlpha2Map = null;

    protected static Properties readPropertyFiles(URI propertyFileURI) {
        URIConverterImpl converter = new URIConverterImpl();
        Properties retValue = new Properties();
        BufferedInputStream propertiesInputStream = null;
        try {
            propertiesInputStream = new BufferedInputStream(converter.createInputStream(propertyFileURI));
            retValue.load(propertiesInputStream);
            propertiesInputStream.close();
        }
        catch (FileNotFoundException e) {
            Activator.logError((String)EARTH_ALPHA3_ISO_KEY, (Throwable)e);
        }
        catch (IOException e) {
            Activator.logError((String)EARTH_ALPHA3_ISO_KEY, (Throwable)e);
        }
        return retValue;
    }

    protected static int keyLevel(String key) {
        int level = 0;
        int start = 0;
        int temp = key.indexOf("-");
        while (temp > 0) {
            ++level;
            temp = key.substring(start += temp + 1).indexOf("-");
        }
        return level;
    }

    protected static Properties getAlpha2ToAlpha3Map() {
        if (alpha2ToAlpha3Map == null) {
            alpha2ToAlpha3Map = GeographicMapper.readPropertyFiles(LEVEL_0_ISO_MAPPING_FILE_URI);
        }
        if (alpha2ToAlpha3Map == null) {
            Activator.logError((String)"Can't read the alpha2 to alpha3 mapping file \"level0ISOKeys.properties\"", null);
        }
        return alpha2ToAlpha3Map;
    }

    public static String getAlpha3(String alpha2ISOKey) {
        String retValue = alpha2ISOKey;
        Properties alpha2ToAlpha3Map = GeographicMapper.getAlpha2ToAlpha3Map();
        if (alpha2ToAlpha3Map != null) {
            retValue = alpha2ToAlpha3Map.getProperty(alpha2ISOKey);
        }
        return retValue;
    }

    public static String getAlpha2(String alpha3ISOKey) {
        String retValue = alpha3ISOKey;
        Properties alpha3toAlpha2Map = GeographicMapper.getAlpha3toAlpha2Map();
        if (alpha3toAlpha2Map != null) {
            retValue = alpha3toAlpha2Map.getProperty(alpha3ISOKey);
        }
        return retValue;
    }

    private static Properties getAlpha3toAlpha2Map() {
        Properties alpha2ToAlpha3Map;
        if (alpha3ToAlpha2Map == null && (alpha2ToAlpha3Map = GeographicMapper.getAlpha2ToAlpha3Map()) != null) {
            alpha3ToAlpha2Map = new Properties();
            for (Map.Entry<Object, Object> entry : alpha2ToAlpha3Map.entrySet()) {
                alpha3ToAlpha2Map.put(entry.getValue(), entry.getKey());
            }
        }
        return alpha3ToAlpha2Map;
    }

    protected static String makeBundleName(String alpha3ISOKey, String bundlePrefix, String bundleType) {
        StringBuilder sb = new StringBuilder(bundlePrefix);
        sb.append(".");
        sb.append(alpha3ISOKey);
        sb.append("_");
        sb.append(bundleType);
        return sb.toString();
    }

    protected static ResourceBundle readResourceBundle(String alpha2ISOKey, String bundlePrefix, String bundleType) {
        ResourceBundle retValue = null;
        Properties alpha2ToAlpha3Map = GeographicMapper.getAlpha2ToAlpha3Map();
        if (alpha2ToAlpha3Map != null) {
            String alpha3ISOKey = alpha2ToAlpha3Map.getProperty(alpha2ISOKey);
            retValue = ResourceBundle.getBundle(GeographicMapper.makeBundleName(alpha3ISOKey, bundlePrefix, bundleType));
        }
        return retValue;
    }

    protected static ResourceBundle getResourceBundle(String isoKey, int level, String bundlePrefix, String bundleType, String level0RBName, ResourceBundle level0RB, Map<String, ResourceBundle> rbMap) {
        ResourceBundle retValue = null;
        if (level == -1 || level == 0) {
            if (level0RB == null) {
                level0RB = ResourceBundle.getBundle(level0RBName);
            }
            retValue = level0RB;
        } else {
            String alpha2ISOKey = isoKey.substring(0, 2);
            retValue = rbMap.get(alpha2ISOKey);
            if (retValue == null) {
                retValue = GeographicMapper.readResourceBundle(alpha2ISOKey, bundlePrefix, bundleType);
                if (retValue == null) {
                    Activator.logError((String)("Could not read Resource Bundle of type " + bundleType + " for \"" + alpha2ISOKey + "\""), null);
                } else {
                    rbMap.put(alpha2ISOKey, retValue);
                }
            }
        }
        return retValue;
    }
}

