/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class MainMethodSearchEngine {
    public IType[] searchMainMethods(IProgressMonitor pm, IJavaSearchScope scope, boolean includeSubtypes) {
        pm.beginTask(LauncherMessages.MainMethodSearchEngine_1, 100);
        int searchTicks = 100;
        if (includeSubtypes) {
            searchTicks = 25;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)"main(String[]) void", (int)1, (int)0, (int)8);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        MethodCollector collector = new MethodCollector();
        SubProgressMonitor searchMonitor = new SubProgressMonitor(pm, searchTicks);
        try {
            new SearchEngine().search(pattern, participants, scope, (SearchRequestor)collector, (IProgressMonitor)searchMonitor);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        List<IType> result = collector.getResult();
        if (includeSubtypes) {
            SubProgressMonitor subtypesMonitor = new SubProgressMonitor(pm, 75);
            subtypesMonitor.beginTask(LauncherMessages.MainMethodSearchEngine_2, result.size());
            Set<IType> set = this.addSubtypes(result, (IProgressMonitor)subtypesMonitor, scope);
            return set.toArray(new IType[set.size()]);
        }
        return result.toArray(new IType[result.size()]);
    }

    private Set<IType> addSubtypes(List<IType> types, IProgressMonitor monitor, IJavaSearchScope scope) {
        Iterator<IType> iterator = types.iterator();
        HashSet<IType> result = new HashSet<IType>(types.size());
        IType type = null;
        ITypeHierarchy hierarchy = null;
        IType[] subtypes = null;
        while (iterator.hasNext()) {
            type = iterator.next();
            if (result.add(type)) {
                try {
                    hierarchy = type.newTypeHierarchy(monitor);
                    subtypes = hierarchy.getAllSubtypes(type);
                    int i = 0;
                    while (i < subtypes.length) {
                        if (scope.encloses((IJavaElement)subtypes[i])) {
                            result.add(subtypes[i]);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            monitor.worked(1);
        }
        return result;
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public IType[] searchMainMethods(IRunnableContext context, final IJavaSearchScope scope, final boolean includeSubtypes) throws InvocationTargetException, InterruptedException {
        final IType[][] res = new IType[1][];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                res[0] = MainMethodSearchEngine.this.searchMainMethods(pm, scope, includeSubtypes);
            }
        };
        context.run(true, true, runnable);
        return res[0];
    }

    private class MethodCollector
    extends SearchRequestor {
        private List<IType> fResult = new ArrayList<IType>(200);

        public List<IType> getResult() {
            return this.fResult;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object enclosingElement = match.getElement();
            if (enclosingElement instanceof IMethod) {
                try {
                    IMethod curr = (IMethod)enclosingElement;
                    if (curr.isMainMethod()) {
                        IType declaringType = curr.getDeclaringType();
                        this.fResult.add(declaringType);
                    }
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log(e.getStatus());
                }
            }
        }
    }
}

