/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.imagewriter.logger.projections;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.stem.loggers.imagewriter.logger.projections.IMapProjection;

public class AzimuthalEquidistant
implements IMapProjection {
    private Point2D origin = new Point2D.Double(0.0, 0.0);
    private static final Rectangle2D PROJECTION_BOUNDS = new Rectangle2D.Double(-180.0, -180.0, 360.0, 360.0);

    @Override
    public double[] project(double lat, double lon) {
        double lam0 = Math.toRadians(this.origin.getX());
        double phi0 = Math.toRadians(this.origin.getY());
        double phi = Math.toRadians(lat);
        double lam = Math.toRadians(lon);
        double c = Math.acos(Math.sin(phi0) * Math.sin(phi) + Math.cos(phi0) * Math.cos(phi) * Math.cos(lam - lam0));
        double k = c / Math.sin(c);
        double lonNew = k * Math.cos(phi) * Math.sin(lam - lam0);
        double latNew = k * (Math.cos(phi0) * Math.sin(phi) - Math.sin(phi0) * Math.cos(phi) * Math.cos(lam - lam0));
        return new double[]{Math.toDegrees(latNew), Math.toDegrees(lonNew)};
    }

    @Override
    public double[] project(double lat, double lon, double lat0, double lon0, boolean distort) {
        return this.project(lat, lon);
    }

    @Override
    public double[] inverseProject(double lat, double lon) {
        return new double[]{lat, lon};
    }

    @Override
    public double[] inverseProject(double lat, double lon, double lat0, double lon0, boolean distort) {
        return this.inverseProject(lat, lon);
    }

    @Override
    public void setOrigin(double lat, double lon) {
        this.origin = new Point2D.Double(lon, lat);
    }

    @Override
    public Rectangle2D getBounds() {
        return PROJECTION_BOUNDS;
    }
}

