/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.patch.HunkTypedElement;
import org.eclipse.compare.internal.patch.PatchCompareEditorInput;
import org.eclipse.compare.internal.patch.PatchDiffNode;
import org.eclipse.compare.internal.patch.PatchFileDiffNode;
import org.eclipse.compare.internal.patch.Utilities;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Image;

public class PatchProjectDiffNode
extends PatchDiffNode {
    private final DiffProject project;
    private final PatchConfiguration configuration;

    public PatchProjectDiffNode(IDiffContainer parent, DiffProject project, PatchConfiguration configuration) {
        super(project, parent, 0);
        this.project = project;
        this.configuration = configuration;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public Image getImage() {
        Image image = CompareUI.getImage((IAdaptable)Utilities.getProject(this.project));
        if (this.containsProblems()) {
            LocalResourceManager imageCache = PatchCompareEditorInput.getImageCache(this.getConfiguration());
            image = HunkTypedElement.getHunkErrorImage(image, imageCache, true);
        }
        return image;
    }

    private boolean containsProblems() {
        IDiffElement[] elements = this.getChildren();
        int i = 0;
        while (i < elements.length) {
            PatchFileDiffNode node;
            IDiffElement diffElement = elements[i];
            if (diffElement instanceof PatchFileDiffNode && (node = (PatchFileDiffNode)diffElement).getDiffResult().containsProblems()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String getType() {
        return "FOLDER";
    }

    @Override
    protected PatchConfiguration getConfiguration() {
        return this.configuration;
    }

    public DiffProject getDiffProject() {
        return this.project;
    }

    @Override
    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getDiffProject().getName());
    }
}

