/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.refactoring.participant;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.util.Strings;

public class JvmElementFinder {
    @Inject
    private IJvmTypeProvider.Factory typeProviderFactory;
    @Inject
    private TypeURIHelper typeURIHelper;
    @Inject
    private IResourceDescriptions resourceDescriptions;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public EObject getCorrespondingJvmElement(IJavaElement javaElement, ResourceSet resourceSet) {
        this.typeProviderFactory.findOrCreateTypeProvider(resourceSet);
        URI jvmElementURI = this.typeURIHelper.getFullURI(javaElement);
        return jvmElementURI != null ? resourceSet.getEObject(jvmElementURI, true) : null;
    }

    public EObject findJvmElementDeclarationInIndex(EObject jvmElement, IProject project) {
        QualifiedName qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName(jvmElement);
        if (qualifiedName != null) {
            for (IResourceDescription resourceDescription : this.resourceDescriptions.getAllResourceDescriptions()) {
                Iterator matches;
                if (!resourceDescription.getURI().isPlatformResource() || !Strings.equal((String)project.getName(), (String)resourceDescription.getURI().segment(1)) || !(matches = resourceDescription.getExportedObjects(jvmElement.eClass(), qualifiedName, true).iterator()).hasNext()) continue;
                return jvmElement.eResource().getResourceSet().getEObject(((IEObjectDescription)matches.next()).getEObjectURI(), true);
            }
        }
        return null;
    }
}

