/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.bidi.custom.STextTypeHandler;
import org.eclipse.equinox.bidi.internal.STextActivator;

public class STextTypesCollector
implements IRegistryEventListener {
    private static final String EXT_POINT = "org.eclipse.equinox.bidi.bidiTypes";
    private static final String CE_NAME = "typeDescription";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_HANDLER = "class";
    private Map types;
    private Map factories;
    private static STextTypesCollector instance = new STextTypesCollector();

    private STextTypesCollector() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        registry.addListener((IRegistryEventListener)this, EXT_POINT);
    }

    public static STextTypesCollector getInstance() {
        return instance;
    }

    public String[] getTypes() {
        if (this.types == null) {
            this.read();
        }
        int size = this.types.size();
        String[] result = new String[size];
        this.types.keySet().toArray(result);
        return result;
    }

    public STextTypeHandler getHandler(String type) {
        Object handler;
        if (this.types == null) {
            this.read();
        }
        if ((handler = this.types.get(type)) instanceof STextTypeHandler) {
            return (STextTypeHandler)handler;
        }
        return null;
    }

    private void read() {
        if (this.types == null) {
            this.types = new HashMap();
        } else {
            this.types.clear();
        }
        if (this.factories == null) {
            this.factories = new HashMap();
        } else {
            this.factories.clear();
        }
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(EXT_POINT);
        IExtension[] extensions = extPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] confElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < confElements.length) {
                block9: {
                    Object handler;
                    if (!CE_NAME.equals(confElements[j].getName())) {
                        STextActivator.logError("BiDi types: unexpected element name " + confElements[j].getName(), new IllegalArgumentException());
                    }
                    String type = confElements[j].getAttribute(ATTR_TYPE);
                    try {
                        handler = confElements[j].createExecutableExtension(ATTR_HANDLER);
                    }
                    catch (CoreException e) {
                        STextActivator.logError("BiDi types: unable to create handler for " + type, (Exception)((Object)e));
                        break block9;
                    }
                    this.types.put(type, handler);
                    this.factories.put(type, confElements[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public void added(IExtension[] extensions) {
        this.types = null;
        this.factories = null;
    }

    public void removed(IExtension[] extensions) {
        this.types = null;
        this.factories = null;
    }

    public void added(IExtensionPoint[] extensionPoints) {
        this.types = null;
        this.factories = null;
    }

    public void removed(IExtensionPoint[] extensionPoints) {
        this.types = null;
        this.factories = null;
    }
}

