/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.birt.core.archive.ArchiveLockManager;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IArchiveLockManager;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.i18n.CoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderArchive
implements IDocArchiveWriter,
IDocArchiveReader {
    private String folderName;
    private FolderArchiveReader reader;
    private FolderArchiveWriter writer;
    private boolean isOpen = false;

    public FolderArchive(String folderName) throws IOException {
        if (folderName == null || folderName.length() == 0) {
            throw new IOException(CoreMessages.getString("error.FolderNameIsNull"));
        }
        this.folderName = new File(folderName).getCanonicalPath();
        try {
            this.writer = new FolderArchiveWriter(folderName);
            this.reader = new FolderArchiveReader(folderName);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public String getName() {
        return this.folderName;
    }

    @Override
    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        return this.writer.createRandomAccessStream(relativePath);
    }

    @Override
    public RAOutputStream openRandomAccessStream(String relativePath) throws IOException {
        return this.writer.openRandomAccessStream(relativePath);
    }

    @Override
    public RAOutputStream createOutputStream(String relativePath) throws IOException {
        return this.createRandomAccessStream(relativePath);
    }

    @Override
    public RAOutputStream getOutputStream(String relativePath) throws IOException {
        return this.openRandomAccessStream(relativePath);
    }

    @Override
    public RAInputStream getInputStream(String relativePath) throws IOException {
        return this.reader.getInputStream(relativePath);
    }

    @Override
    public boolean dropStream(String relativePath) {
        return this.writer.dropStream(relativePath);
    }

    @Override
    public boolean exists(String relativePath) {
        return this.writer.exists(relativePath);
    }

    @Override
    public void setStreamSorter(IStreamSorter streamSorter) {
        this.writer.setStreamSorter(streamSorter);
    }

    @Override
    public void finish() throws IOException {
        this.close();
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public RAInputStream getStream(String relativePath) throws IOException {
        return this.reader.getStream(relativePath);
    }

    @Override
    public List<String> listStreams(String relativeStoragePath) throws IOException {
        return this.reader.listStreams(relativeStoragePath);
    }

    @Override
    public List<String> listAllStreams() throws IOException {
        return this.reader.listAllStreams();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen) {
            this.isOpen = false;
            try {
                this.writer.finish();
            }
            finally {
                this.reader.close();
            }
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public Object lock(String stream) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, String.valueOf(stream) + ".lck");
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        return lockManager.lock(path);
    }

    @Override
    public void unlock(Object lock) {
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        lockManager.unlock(lock);
    }
}

