/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.search;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.util.ResourceLocator;
import org.eclipse.help.search.ISearchIndex;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LuceneSearchParticipant {
    private static final HashSet<String> EMPTY_SET = new HashSet();
    private String id;

    public final void init(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public abstract IStatus addDocument(ISearchIndex var1, String var2, String var3, URL var4, String var5, Document var6);

    public Set<String> getAllDocuments(String locale) {
        return EMPTY_SET;
    }

    public Set<String> getContributingPlugins() {
        return EMPTY_SET;
    }

    protected static String resolveVariables(String pluginId, String fileName, String locale) {
        if (fileName.indexOf(36) == -1) {
            return fileName;
        }
        ArrayList prefix = ResourceLocator.getPathPrefix((String)locale);
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return fileName;
        }
        URL url = ResourceLocator.find((Bundle)bundle, (IPath)new Path(fileName), (ArrayList)prefix);
        URL root = FileLocator.find((Bundle)bundle, (IPath)new Path(""), null);
        return url.toString().substring(root.toString().length());
    }

    protected void addTitle(String title, Document doc) {
        doc.add((Fieldable)new Field("title", title, Field.Store.NO, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("exact_title", title, Field.Store.NO, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("raw_title", title, Field.Store.YES, Field.Index.NO));
    }

    public boolean open(String id) {
        return false;
    }

    public void clear() {
    }
}

